/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.openai;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.external.openai.OpenAiUnifiedStreamingProcessor;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;

public class OpenAiUnifiedChatCompletionResponseHandler
extends OpenAiChatCompletionResponseHandler {
    public OpenAiUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, OpenAiErrorResponse::fromResponse);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        OpenAiUnifiedStreamingProcessor openAiProcessor = new OpenAiUnifiedStreamingProcessor((m, e) -> OpenAiUnifiedChatCompletionResponseHandler.buildMidStreamError(request, m, e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(openAiProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)openAiProcessor);
    }

    @Override
    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        if (request.isStreaming()) {
            UnifiedChatCompletionException unifiedChatCompletionException;
            String errorMessage = this.errorMessage(message, request, result, errorResponse, responseStatusCode);
            RestStatus restStatus = OpenAiUnifiedChatCompletionResponseHandler.toRestStatus(responseStatusCode);
            if (errorResponse instanceof OpenAiErrorResponse) {
                OpenAiErrorResponse oer = (OpenAiErrorResponse)errorResponse;
                unifiedChatCompletionException = new UnifiedChatCompletionException(restStatus, errorMessage, oer.type(), oer.code(), oer.param());
            } else {
                unifiedChatCompletionException = new UnifiedChatCompletionException(restStatus, errorMessage, errorResponse != null ? errorResponse.getClass().getSimpleName() : "unknown", restStatus.name().toLowerCase(Locale.ROOT));
            }
            return unifiedChatCompletionException;
        }
        return super.buildError(message, request, result, errorResponse);
    }

    private static Exception buildMidStreamError(Request request, String message, Exception e) {
        ErrorResponse errorResponse = OpenAiErrorResponse.fromString(message);
        if (errorResponse instanceof OpenAiErrorResponse) {
            OpenAiErrorResponse oer = (OpenAiErrorResponse)errorResponse;
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]. Error message: [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId(), errorResponse.getErrorMessage()}), oer.type(), oer.code(), oer.param());
        }
        if (e != null) {
            return UnifiedChatCompletionException.fromThrowable((Throwable)e);
        }
        return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId()}), errorResponse != null ? errorResponse.getClass().getSimpleName() : "unknown", "stream_error");
    }

    private static class OpenAiErrorResponse
    extends ErrorResponse {
        private static final ConstructingObjectParser<Optional<ErrorResponse>, Void> ERROR_PARSER = new ConstructingObjectParser("open_ai_error", true, args -> Optional.ofNullable((OpenAiErrorResponse)args[0]));
        private static final ConstructingObjectParser<OpenAiErrorResponse, Void> ERROR_BODY_PARSER = new ConstructingObjectParser("open_ai_error", true, args -> new OpenAiErrorResponse((String)args[0], (String)args[1], (String)args[2], (String)args[3]));
        @Nullable
        private final String code;
        @Nullable
        private final String param;
        private final String type;

        private static ErrorResponse fromResponse(HttpResult response) {
            ErrorResponse errorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());
                try {
                    errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return ErrorResponse.UNDEFINED_ERROR;
                    }
                }
                parser.close();
            }
            return errorResponse;
        }

        private static ErrorResponse fromString(String response) {
            ErrorResponse errorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);
                try {
                    errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return ErrorResponse.UNDEFINED_ERROR;
                    }
                }
                parser.close();
            }
            return errorResponse;
        }

        OpenAiErrorResponse(String errorMessage, @Nullable String code, @Nullable String param, String type) {
            super(errorMessage);
            this.code = code;
            this.param = param;
            this.type = Objects.requireNonNull(type);
        }

        @Nullable
        public String code() {
            return this.code;
        }

        @Nullable
        public String param() {
            return this.param;
        }

        public String type() {
            return this.type;
        }

        static {
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("message", new String[0]));
            ERROR_BODY_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("code", new String[0]));
            ERROR_BODY_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("param", new String[0]));
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
            ERROR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_BODY_PARSER, null, new ParseField("error", new String[0]));
        }
    }
}

