/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.googleaistudio;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.googleaistudio.GoogleAiStudioEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.external.request.googleaistudio.GoogleAiStudioRequest;
import org.elasticsearch.xpack.inference.services.googleaistudio.embeddings.GoogleAiStudioEmbeddingsModel;

public class GoogleAiStudioEmbeddingsRequest
implements GoogleAiStudioRequest {
    private final Truncator truncator;
    private final Truncator.TruncationResult truncationResult;
    private final GoogleAiStudioEmbeddingsModel model;

    public GoogleAiStudioEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, GoogleAiStudioEmbeddingsModel model) {
        this.truncator = Objects.requireNonNull(truncator);
        this.truncationResult = Objects.requireNonNull(input);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new GoogleAiStudioEmbeddingsRequestEntity(this.truncationResult.input(), this.model.getServiceSettings().modelId(), this.model.getServiceSettings().dimensions())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        GoogleAiStudioRequest.decorateWithApiKeyParameter(httpPost, this.model.getSecretSettings());
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new GoogleAiStudioEmbeddingsRequest(this.truncator, truncatedInput, this.model);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }
}

