/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.openai;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record OpenAiEmbeddingsRequestEntity(List<String> input, String model, @Nullable String user, @Nullable Integer dimensions, boolean dimensionsSetByUser) implements ToXContentObject
{
    private static final String INPUT_FIELD = "input";
    private static final String MODEL_FIELD = "model";
    private static final String USER_FIELD = "user";
    private static final String DIMENSIONS_FIELD = "dimensions";

    public OpenAiEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(model);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INPUT_FIELD, this.input);
        builder.field(MODEL_FIELD, this.model);
        if (this.user != null) {
            builder.field(USER_FIELD, this.user);
        }
        if (this.dimensionsSetByUser && this.dimensions != null) {
            builder.field(DIMENSIONS_FIELD, this.dimensions);
        }
        builder.endObject();
        return builder;
    }
}

