/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class AlibabaCloudSearchEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "alibabacloud_search_embeddings_task_settings";
    public static final AlibabaCloudSearchEmbeddingsTaskSettings EMPTY_SETTINGS = new AlibabaCloudSearchEmbeddingsTaskSettings((InputType)null);
    static final String INPUT_TYPE = "input_type";
    static final EnumSet<InputType> VALID_REQUEST_VALUES = EnumSet.of(InputType.INGEST, InputType.SEARCH);
    private final InputType inputType;

    public static AlibabaCloudSearchEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, INPUT_TYPE, "task_settings", InputType::fromString, VALID_REQUEST_VALUES, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AlibabaCloudSearchEmbeddingsTaskSettings(inputType);
    }

    public static AlibabaCloudSearchEmbeddingsTaskSettings of(AlibabaCloudSearchEmbeddingsTaskSettings originalSettings, AlibabaCloudSearchEmbeddingsTaskSettings requestTaskSettings, InputType requestInputType) {
        InputType inputTypeToUse = AlibabaCloudSearchEmbeddingsTaskSettings.getValidInputType(originalSettings, requestTaskSettings, requestInputType);
        return new AlibabaCloudSearchEmbeddingsTaskSettings(inputTypeToUse);
    }

    public boolean isEmpty() {
        return this.inputType == null;
    }

    private static InputType getValidInputType(AlibabaCloudSearchEmbeddingsTaskSettings originalSettings, AlibabaCloudSearchEmbeddingsTaskSettings requestTaskSettings, InputType requestInputType) {
        InputType inputTypeToUse = originalSettings.inputType;
        if (VALID_REQUEST_VALUES.contains(requestInputType)) {
            inputTypeToUse = requestInputType;
        } else if (requestTaskSettings.inputType != null) {
            inputTypeToUse = requestTaskSettings.inputType;
        }
        return inputTypeToUse;
    }

    public AlibabaCloudSearchEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this((InputType)in.readOptionalEnum(InputType.class));
    }

    public AlibabaCloudSearchEmbeddingsTaskSettings(@Nullable InputType inputType) {
        AlibabaCloudSearchEmbeddingsTaskSettings.validateInputType(inputType);
        this.inputType = inputType;
    }

    private static void validateInputType(InputType inputType) {
        if (inputType == null) {
            return;
        }
        assert (VALID_REQUEST_VALUES.contains(inputType)) : AlibabaCloudSearchEmbeddingsTaskSettings.invalidInputTypeMessage(inputType);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.inputType != null) {
            builder.field(INPUT_TYPE, (Enum)this.inputType);
        }
        builder.endObject();
        return builder;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.inputType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlibabaCloudSearchEmbeddingsTaskSettings that = (AlibabaCloudSearchEmbeddingsTaskSettings)o;
        return Objects.equals(this.inputType, that.inputType);
    }

    public int hashCode() {
        return Objects.hash(this.inputType);
    }

    public static String invalidInputTypeMessage(InputType inputType) {
        return Strings.format((String)"received invalid input type value [%s]", (Object[])new Object[]{inputType.toString()});
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AlibabaCloudSearchEmbeddingsTaskSettings newSettingsOnly = AlibabaCloudSearchEmbeddingsTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AlibabaCloudSearchEmbeddingsTaskSettings.of(this, newSettingsOnly, newSettingsOnly.inputType != null ? newSettingsOnly.inputType : this.getInputType());
    }
}

