/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.inference.results.InferenceTextEmbeddingFloatResults;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.action.GetDeploymentStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentStats;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextExpansionResults;
import org.elasticsearch.xpack.core.ml.inference.results.TextSimilarityInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.EmptyConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextExpansionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextExpansionConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextSimilarityConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextSimilarityConfigUpdate;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.BaseElasticsearchInternalService;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandEmbeddingModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalTextEmbeddingServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandRerankModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticDeployedModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticRerankerModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticRerankerServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserMlNodeTaskSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserModels;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.RerankTaskSettings;

public class ElasticsearchInternalService
extends BaseElasticsearchInternalService {
    public static final String NAME = "elasticsearch";
    public static final String OLD_ELSER_SERVICE_NAME = "elser";
    static final String MULTILINGUAL_E5_SMALL_MODEL_ID = ".multilingual-e5-small";
    static final String MULTILINGUAL_E5_SMALL_MODEL_ID_LINUX_X86 = ".multilingual-e5-small_linux-x86_64";
    public static final Set<String> MULTILINGUAL_E5_SMALL_VALID_IDS = Set.of(".multilingual-e5-small", ".multilingual-e5-small_linux-x86_64");
    public static final String RERANKER_ID = ".rerank-v1";
    public static final int EMBEDDING_MAX_BATCH_SIZE = 10;
    public static final String DEFAULT_ELSER_ID = ".elser-2-elasticsearch";
    public static final String DEFAULT_E5_ID = ".multilingual-e5-small-elasticsearch";
    public static final String DEFAULT_RERANK_ID = ".rerank-v1-elasticsearch";
    private static final String SERVICE_NAME = "Elasticsearch";
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.RERANK, TaskType.TEXT_EMBEDDING, TaskType.SPARSE_EMBEDDING);
    private static final Logger logger = LogManager.getLogger(ElasticsearchInternalService.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(ElasticsearchInternalService.class);
    private static final String OLD_MODEL_ID_FIELD_NAME = "model_version";
    private final Settings settings;

    public ElasticsearchInternalService(InferenceServiceExtension.InferenceServiceFactoryContext context) {
        super(context);
        this.settings = context.settings();
    }

    ElasticsearchInternalService(InferenceServiceExtension.InferenceServiceFactoryContext context, Consumer<ActionListener<BaseElasticsearchInternalService.PreferredModelVariant>> platformArch) {
        super(context, platformArch);
        this.settings = context.settings();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> modelListener) {
        if (this.isDefaultId(inferenceEntityId)) {
            modelListener.onFailure((Exception)((Object)new ElasticsearchStatusException("[{}] is a reserved inference Id. Cannot create a new inference endpoint with a reserved Id", RestStatus.BAD_REQUEST, new Object[]{inferenceEntityId})));
            return;
        }
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            String serviceName = (String)config.remove("service");
            if (TaskType.TEXT_EMBEDDING.equals((Object)taskType) || TaskType.SPARSE_EMBEDDING.equals((Object)taskType)) {
                ChunkingSettings chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            } else {
                Object var8_10 = null;
            }
            ServiceUtils.throwIfNotEmptyMap(config, this.name());
            String modelId = (String)serviceSettingsMap.get("model_id");
            String deploymentId = (String)serviceSettingsMap.get("deployment_id");
            if (deploymentId != null) {
                this.validateAgainstDeployment(modelId, deploymentId, taskType, (ActionListener<ElasticsearchInternalServiceSettings.Builder>)modelListener.delegateFailureAndWrap((arg_0, arg_1) -> ElasticsearchInternalService.lambda$parseRequestConfig$0(inferenceEntityId, taskType, (ChunkingSettings)var8_11, arg_0, arg_1)));
                return;
            } else if (modelId == null) {
                if (!OLD_ELSER_SERVICE_NAME.equals(serviceName)) throw new IllegalArgumentException("Error parsing service settings, model_id must be provided");
                DEPRECATION_LOGGER.critical(DeprecationCategory.API, "inference_api_null_model_id_in_elasticsearch_service", "Putting elasticsearch service inference endpoints (including elser service) without a model_id field is deprecated and will be removed in a future release. Please specify a model_id field.", new Object[0]);
                this.preferredModelVariantFn.accept(modelListener.delegateFailureAndWrap((arg_0, arg_1) -> this.lambda$parseRequestConfig$1(inferenceEntityId, taskType, config, serviceSettingsMap, (ChunkingSettings)var8_11, modelListener, arg_0, arg_1)));
                return;
            } else if (MULTILINGUAL_E5_SMALL_VALID_IDS.contains(modelId)) {
                this.preferredModelVariantFn.accept(modelListener.delegateFailureAndWrap((arg_0, arg_1) -> this.lambda$parseRequestConfig$2(inferenceEntityId, taskType, config, serviceSettingsMap, (ChunkingSettings)var8_11, modelListener, arg_0, arg_1)));
                return;
            } else if (ElserModels.isValidModel(modelId)) {
                this.preferredModelVariantFn.accept(modelListener.delegateFailureAndWrap((arg_0, arg_1) -> this.lambda$parseRequestConfig$3(inferenceEntityId, taskType, config, serviceSettingsMap, serviceName, (ChunkingSettings)var8_11, modelListener, arg_0, arg_1)));
                return;
            } else if (RERANKER_ID.equals(modelId)) {
                this.rerankerCase(inferenceEntityId, taskType, config, serviceSettingsMap, taskSettingsMap, modelListener);
                return;
            } else {
                this.customElandCase(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, (ChunkingSettings)var8_11, modelListener);
            }
            return;
        }
        catch (Exception e) {
            modelListener.onFailure(e);
        }
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    private void customElandCase(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettingsMap, Map<String, Object> taskSettingsMap, ChunkingSettings chunkingSettings, ActionListener<Model> modelListener) {
        String modelId = (String)serviceSettingsMap.get("model_id");
        GetTrainedModelsAction.Request request = new GetTrainedModelsAction.Request(modelId);
        ActionListener getModelsListener = modelListener.delegateFailureAndWrap((delegate, response) -> {
            if (response.getResources().count() < 1L) {
                throw new IllegalArgumentException("Error parsing request config, model id does not match any models available on this platform. Was [" + modelId + "]. You may need to load it into the cluster using eland.");
            }
            ElasticsearchInternalService.throwIfUnsupportedTaskType(modelId, taskType, ((TrainedModelConfig)response.getResources().results().get(0)).getInferenceConfig());
            CustomElandModel model = ElasticsearchInternalService.createCustomElandModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, this.name());
            delegate.onResponse((Object)model);
        });
        this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)request, getModelsListener);
    }

    private static CustomElandModel createCustomElandModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new CustomElandEmbeddingModel(inferenceEntityId, taskType, NAME, CustomElandInternalTextEmbeddingServiceSettings.fromMap(serviceSettings, context), chunkingSettings);
            case TaskType.SPARSE_EMBEDDING -> new CustomElandModel(inferenceEntityId, taskType, NAME, (ElasticsearchInternalServiceSettings)ElasticsearchInternalService.elandServiceSettings(serviceSettings, context), chunkingSettings);
            case TaskType.RERANK -> new CustomElandRerankModel(inferenceEntityId, taskType, NAME, ElasticsearchInternalService.elandServiceSettings(serviceSettings, context), RerankTaskSettings.fromMap(taskSettings));
            default -> throw new ElasticsearchStatusException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    private static CustomElandInternalServiceSettings elandServiceSettings(Map<String, Object> settingsMap, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new MatchException(null, null);
            case ConfigurationParseContext.REQUEST -> new CustomElandInternalServiceSettings(ElasticsearchInternalServiceSettings.fromRequestMap(settingsMap).build());
            case ConfigurationParseContext.PERSISTENT -> new CustomElandInternalServiceSettings(ElasticsearchInternalServiceSettings.fromPersistedMap(settingsMap));
        };
    }

    private void rerankerCase(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> serviceSettingsMap, Map<String, Object> taskSettingsMap, ActionListener<Model> modelListener) {
        ElasticsearchInternalServiceSettings.Builder esServiceSettingsBuilder = ElasticsearchInternalServiceSettings.fromRequestMap(serviceSettingsMap);
        ServiceUtils.throwIfNotEmptyMap(config, this.name());
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
        modelListener.onResponse((Object)new ElasticRerankerModel(inferenceEntityId, taskType, NAME, new ElasticRerankerServiceSettings(esServiceSettingsBuilder.build()), RerankTaskSettings.fromMap(taskSettingsMap)));
    }

    private void e5Case(String inferenceEntityId, TaskType taskType, Map<String, Object> config, BaseElasticsearchInternalService.PreferredModelVariant preferredModelVariant, Map<String, Object> serviceSettingsMap, ChunkingSettings chunkingSettings, ActionListener<Model> modelListener) {
        ElasticsearchInternalServiceSettings.Builder esServiceSettingsBuilder = ElasticsearchInternalServiceSettings.fromRequestMap(serviceSettingsMap);
        if (esServiceSettingsBuilder.getModelId() == null) {
            esServiceSettingsBuilder.setModelId(ElasticsearchInternalService.selectDefaultModelVariantBasedOnClusterArchitecture(preferredModelVariant, MULTILINGUAL_E5_SMALL_MODEL_ID_LINUX_X86, MULTILINGUAL_E5_SMALL_MODEL_ID));
        } else if (!ElasticsearchInternalService.modelVariantValidForArchitecture(preferredModelVariant, esServiceSettingsBuilder.getModelId())) {
            throw new IllegalArgumentException("Error parsing request config, model id does not match any models available on this platform. Was [" + esServiceSettingsBuilder.getModelId() + "]");
        }
        ServiceUtils.throwIfNotEmptyMap(config, this.name());
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
        modelListener.onResponse((Object)new MultilingualE5SmallModel(inferenceEntityId, taskType, NAME, new MultilingualE5SmallInternalServiceSettings(esServiceSettingsBuilder.build()), chunkingSettings));
    }

    static boolean modelVariantValidForArchitecture(BaseElasticsearchInternalService.PreferredModelVariant modelVariant, String modelId) {
        if (modelId.equals(MULTILINGUAL_E5_SMALL_MODEL_ID)) {
            return true;
        }
        return modelId.equals(ElasticsearchInternalService.selectDefaultModelVariantBasedOnClusterArchitecture(modelVariant, MULTILINGUAL_E5_SMALL_MODEL_ID_LINUX_X86, MULTILINGUAL_E5_SMALL_MODEL_ID));
    }

    private void elserCase(String inferenceEntityId, TaskType taskType, Map<String, Object> config, BaseElasticsearchInternalService.PreferredModelVariant preferredModelVariant, Map<String, Object> serviceSettingsMap, boolean isElserService, ChunkingSettings chunkingSettings, ActionListener<Model> modelListener) {
        ElasticsearchInternalServiceSettings.Builder esServiceSettingsBuilder = ElasticsearchInternalServiceSettings.fromRequestMap(serviceSettingsMap);
        String defaultModelId = ElasticsearchInternalService.selectDefaultModelVariantBasedOnClusterArchitecture(preferredModelVariant, ".elser_model_2_linux-x86_64", ".elser_model_2");
        if (!defaultModelId.equals(esServiceSettingsBuilder.getModelId())) {
            if (esServiceSettingsBuilder.getModelId() == null) {
                esServiceSettingsBuilder.setModelId(defaultModelId);
            } else if (esServiceSettingsBuilder.getModelId().equals(".elser_model_2")) {
                logger.warn("The platform agnostic model [{}] was requested on Linux x86_64. It is recommended to use the optimized model instead [{}]", (Object)".elser_model_2", (Object)".elser_model_2_linux-x86_64");
            } else {
                throw new IllegalArgumentException("Error parsing request config, model id does not match any models available on this platform. Was [" + esServiceSettingsBuilder.getModelId() + "]. You may need to use a platform agnostic model.");
            }
        }
        if (isElserService) {
            DEPRECATION_LOGGER.warn(DeprecationCategory.API, "inference_api_elser_service", "The [{}] service is deprecated and will be removed in a future release. Use the [{}] service instead, with [model_id] set to [{}] in the [service_settings]", new Object[]{OLD_ELSER_SERVICE_NAME, NAME, defaultModelId});
        }
        ServiceUtils.throwIfNotEmptyMap(config, this.name());
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
        modelListener.onResponse((Object)new ElserInternalModel(inferenceEntityId, taskType, NAME, new ElserInternalServiceSettings(esServiceSettingsBuilder.build()), ElserMlNodeTaskSettings.DEFAULT, chunkingSettings));
    }

    public Model parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        return this.parsePersistedConfig(inferenceEntityId, taskType, config);
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        String modelId;
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        this.migrateModelVersionToModelId(serviceSettingsMap);
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType) || TaskType.SPARSE_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        if ((modelId = (String)serviceSettingsMap.get("model_id")) == null) {
            throw new IllegalArgumentException(Strings.format((String)"Error parsing request config, model id is missing for inference id: %s", (Object[])new Object[]{inferenceEntityId}));
        }
        if (MULTILINGUAL_E5_SMALL_VALID_IDS.contains(modelId)) {
            return new MultilingualE5SmallModel(inferenceEntityId, taskType, NAME, new MultilingualE5SmallInternalServiceSettings(ElasticsearchInternalServiceSettings.fromPersistedMap(serviceSettingsMap)), chunkingSettings);
        }
        if (ElserModels.isValidModel(modelId)) {
            return new ElserInternalModel(inferenceEntityId, taskType, NAME, new ElserInternalServiceSettings(ElasticsearchInternalServiceSettings.fromPersistedMap(serviceSettingsMap)), ElserMlNodeTaskSettings.DEFAULT, chunkingSettings);
        }
        if (modelId.equals(RERANKER_ID)) {
            return new ElasticRerankerModel(inferenceEntityId, taskType, NAME, new ElasticRerankerServiceSettings(ElasticsearchInternalServiceSettings.fromPersistedMap(serviceSettingsMap)), RerankTaskSettings.fromMap(taskSettingsMap));
        }
        return ElasticsearchInternalService.createCustomElandModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, ConfigurationParseContext.PERSISTENT);
    }

    private void migrateModelVersionToModelId(Map<String, Object> serviceSettingsMap) {
        if (serviceSettingsMap.containsKey(OLD_MODEL_ID_FIELD_NAME)) {
            String modelId = ServiceUtils.removeAsType(serviceSettingsMap, OLD_MODEL_ID_FIELD_NAME, String.class);
            serviceSettingsMap.put("model_id", modelId);
        }
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        CustomElandEmbeddingModel elandModel;
        if (model instanceof CustomElandEmbeddingModel && (elandModel = (CustomElandEmbeddingModel)model).getTaskType() == TaskType.TEXT_EMBEDDING) {
            CustomElandEmbeddingModel temporaryModelWithModelId = new CustomElandEmbeddingModel(elandModel.getServiceSettings().modelId(), elandModel.getTaskType(), elandModel.getConfigurations().getService(), elandModel.getServiceSettings(), elandModel.getConfigurations().getChunkingSettings());
            ServiceUtils.getEmbeddingSize(temporaryModelWithModelId, this, (ActionListener<Integer>)listener.delegateFailureAndWrap((l, size) -> l.onResponse((Object)ElasticsearchInternalService.updateModelWithEmbeddingDetails(elandModel, size))));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private static CustomElandEmbeddingModel updateModelWithEmbeddingDetails(CustomElandEmbeddingModel model, int embeddingSize) {
        CustomElandInternalTextEmbeddingServiceSettings serviceSettings = new CustomElandInternalTextEmbeddingServiceSettings(model.getServiceSettings().getNumAllocations(), model.getServiceSettings().getNumThreads(), model.getServiceSettings().modelId(), model.getServiceSettings().getAdaptiveAllocationsSettings(), model.getServiceSettings().getDeploymentId(), embeddingSize, model.getServiceSettings().similarity(), model.getServiceSettings().elementType());
        return new CustomElandEmbeddingModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), serviceSettings, model.getConfigurations().getChunkingSettings());
    }

    public void unifiedCompletionInfer(Model model, UnifiedCompletionRequest request, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        ServiceUtils.throwUnsupportedUnifiedCompletionOperation(NAME);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void infer(Model model, @Nullable String query, List<String> input, boolean stream, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (model instanceof ElasticsearchInternalModel) {
            ElasticsearchInternalModel esModel = (ElasticsearchInternalModel)model;
            TaskType taskType = model.getConfigurations().getTaskType();
            if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
                this.inferTextEmbedding(esModel, input, inputType, timeout, listener);
                return;
            } else if (TaskType.RERANK.equals((Object)taskType)) {
                this.inferRerank(esModel, query, input, inputType, timeout, taskSettings, listener);
                return;
            } else {
                if (!TaskType.SPARSE_EMBEDDING.equals((Object)taskType)) throw new ElasticsearchStatusException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)NAME), RestStatus.BAD_REQUEST, new Object[0]);
                this.inferSparseEmbedding(esModel, input, inputType, timeout, listener);
            }
            return;
        } else {
            listener.onFailure((Exception)ElasticsearchInternalService.notElasticsearchModelException(model));
        }
    }

    public void inferTextEmbedding(ElasticsearchInternalModel model, List<String> inputs, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        InferModelAction.Request request = ElasticsearchInternalService.buildInferenceRequest(model.mlNodeDeploymentId(), (InferenceConfigUpdate)TextEmbeddingConfigUpdate.EMPTY_INSTANCE, inputs, inputType, timeout);
        ActionListener mlResultsListener = listener.delegateFailureAndWrap((l, inferenceResult) -> l.onResponse((Object)InferenceTextEmbeddingFloatResults.of((List)inferenceResult.getInferenceResults())));
        ActionListener maybeDeployListener = mlResultsListener.delegateResponse((l, exception) -> this.maybeStartDeployment(model, (Exception)exception, request, (ActionListener<InferModelAction.Response>)mlResultsListener));
        this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)request, maybeDeployListener);
    }

    public void inferSparseEmbedding(ElasticsearchInternalModel model, List<String> inputs, InputType inputType, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        InferModelAction.Request request = ElasticsearchInternalService.buildInferenceRequest(model.mlNodeDeploymentId(), (InferenceConfigUpdate)TextExpansionConfigUpdate.EMPTY_UPDATE, inputs, inputType, timeout);
        ActionListener mlResultsListener = listener.delegateFailureAndWrap((l, inferenceResult) -> l.onResponse((Object)SparseEmbeddingResults.of((List)inferenceResult.getInferenceResults())));
        ActionListener maybeDeployListener = mlResultsListener.delegateResponse((l, exception) -> this.maybeStartDeployment(model, (Exception)exception, request, (ActionListener<InferModelAction.Response>)mlResultsListener));
        this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)request, maybeDeployListener);
    }

    public void inferRerank(ElasticsearchInternalModel model, String query, List<String> inputs, InputType inputType, TimeValue timeout, Map<String, Object> requestTaskSettings, ActionListener<InferenceServiceResults> listener) {
        InferModelAction.Request request = ElasticsearchInternalService.buildInferenceRequest(model.mlNodeDeploymentId(), (InferenceConfigUpdate)new TextSimilarityConfigUpdate(query), inputs, inputType, timeout);
        Boolean returnDocs = Boolean.TRUE;
        TaskSettings taskSettings = model.getTaskSettings();
        if (taskSettings instanceof RerankTaskSettings) {
            RerankTaskSettings modelSettings = (RerankTaskSettings)taskSettings;
            RerankTaskSettings requestSettings = RerankTaskSettings.fromMap(requestTaskSettings);
            returnDocs = RerankTaskSettings.of(modelSettings, requestSettings).returnDocuments();
        }
        Function<Integer, String> inputSupplier = returnDocs == Boolean.TRUE ? inputs::get : i -> null;
        ActionListener mlResultsListener = listener.delegateFailureAndWrap((l, inferenceResult) -> l.onResponse((Object)this.textSimilarityResultsToRankedDocs(inferenceResult.getInferenceResults(), inputSupplier)));
        ActionListener maybeDeployListener = mlResultsListener.delegateResponse((l, exception) -> this.maybeStartDeployment(model, (Exception)exception, request, (ActionListener<InferModelAction.Response>)mlResultsListener));
        this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)request, maybeDeployListener);
    }

    public void chunkedInfer(Model model, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        this.chunkedInfer(model, null, input, taskSettings, inputType, timeout, listener);
    }

    public void chunkedInfer(Model model, @Nullable String query, List<String> input, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        if (!(TaskType.TEXT_EMBEDDING.equals((Object)model.getTaskType()) || TaskType.SPARSE_EMBEDDING.equals((Object)model.getTaskType()))) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException(TaskType.unsupportedTaskTypeErrorMsg((TaskType)model.getTaskType(), (String)NAME), RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        if (model instanceof ElasticsearchInternalModel) {
            ElasticsearchInternalModel esModel = (ElasticsearchInternalModel)model;
            List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(input, 10, ElasticsearchInternalService.embeddingTypeFromTaskTypeAndSettings(model.getTaskType(), esModel.internalServiceSettings), esModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
            if (batchedRequests.isEmpty()) {
                listener.onResponse(List.of());
            } else {
                BatchIterator sequentialRunner = new BatchIterator(esModel, inputType, timeout, batchedRequests);
                sequentialRunner.run();
            }
        } else {
            listener.onFailure((Exception)ElasticsearchInternalService.notElasticsearchModelException(model));
        }
    }

    private static void translateToChunkedResult(TaskType taskType, List<InferenceResults> inferenceResults, ActionListener<InferenceServiceResults> chunkPartListener) {
        if (taskType == TaskType.TEXT_EMBEDDING) {
            ArrayList<InferenceTextEmbeddingFloatResults.InferenceFloatEmbedding> translated = new ArrayList<InferenceTextEmbeddingFloatResults.InferenceFloatEmbedding>();
            for (InferenceResults inferenceResult : inferenceResults) {
                if (inferenceResult instanceof MlTextEmbeddingResults) {
                    MlTextEmbeddingResults mlTextEmbeddingResult = (MlTextEmbeddingResults)inferenceResult;
                    translated.add(new InferenceTextEmbeddingFloatResults.InferenceFloatEmbedding(mlTextEmbeddingResult.getInferenceAsFloat()));
                    continue;
                }
                if (inferenceResult instanceof ErrorInferenceResults) {
                    ErrorInferenceResults error = (ErrorInferenceResults)inferenceResult;
                    chunkPartListener.onFailure(error.getException());
                    return;
                }
                chunkPartListener.onFailure((Exception)((Object)ResultUtils.createInvalidChunkedResultException((String)"text_embedding_result", (String)inferenceResult.getWriteableName())));
                return;
            }
            chunkPartListener.onResponse((Object)new InferenceTextEmbeddingFloatResults(translated));
        } else {
            ArrayList<SparseEmbeddingResults.Embedding> translated = new ArrayList<SparseEmbeddingResults.Embedding>();
            for (InferenceResults inferenceResult : inferenceResults) {
                if (inferenceResult instanceof TextExpansionResults) {
                    TextExpansionResults textExpansionResult = (TextExpansionResults)inferenceResult;
                    translated.add(new SparseEmbeddingResults.Embedding(textExpansionResult.getWeightedTokens(), textExpansionResult.isTruncated()));
                    continue;
                }
                if (inferenceResult instanceof ErrorInferenceResults) {
                    ErrorInferenceResults error = (ErrorInferenceResults)inferenceResult;
                    chunkPartListener.onFailure(error.getException());
                    return;
                }
                chunkPartListener.onFailure((Exception)((Object)ResultUtils.createInvalidChunkedResultException((String)"text_expansion_result", (String)inferenceResult.getWriteableName())));
                return;
            }
            chunkPartListener.onResponse((Object)new SparseEmbeddingResults(translated));
        }
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public String name() {
        return NAME;
    }

    private RankedDocsResults textSimilarityResultsToRankedDocs(List<? extends InferenceResults> results, Function<Integer, String> inputSupplier) {
        ArrayList<RankedDocsResults.RankedDoc> rankings = new ArrayList<RankedDocsResults.RankedDoc>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            InferenceResults result = results.get(i);
            if (!(result instanceof TextSimilarityInferenceResults)) {
                if (result instanceof ErrorInferenceResults) {
                    ErrorInferenceResults errorResult = (ErrorInferenceResults)result;
                    Exception exception = errorResult.getException();
                    if (exception instanceof ElasticsearchStatusException) {
                        ElasticsearchStatusException statusException = (ElasticsearchStatusException)((Object)exception);
                        throw statusException;
                    }
                    throw new ElasticsearchStatusException("Received error inference result.", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)errorResult.getException(), new Object[0]);
                }
                throw new IllegalArgumentException("Received invalid inference result, of type " + result.getClass().getName() + " but expected TextSimilarityInferenceResults.");
            }
            TextSimilarityInferenceResults similarity = (TextSimilarityInferenceResults)result;
            rankings.add(new RankedDocsResults.RankedDoc(i, (float)similarity.score(), inputSupplier.apply(i)));
        }
        Collections.sort(rankings);
        return new RankedDocsResults(rankings);
    }

    public List<InferenceService.DefaultConfigId> defaultConfigIds() {
        return List.of(new InferenceService.DefaultConfigId(DEFAULT_ELSER_ID, ElserInternalServiceSettings.minimalServiceSettings(), (InferenceService)this), new InferenceService.DefaultConfigId(DEFAULT_E5_ID, MultilingualE5SmallInternalServiceSettings.minimalServiceSettings(), (InferenceService)this), new InferenceService.DefaultConfigId(DEFAULT_RERANK_ID, MinimalServiceSettings.rerank(), (InferenceService)this));
    }

    public void updateModelsWithDynamicFields(List<Model> models, ActionListener<List<Model>> listener) {
        if (models.isEmpty()) {
            listener.onResponse(models);
            return;
        }
        if (!((Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(this.settings)).booleanValue()) {
            listener.onResponse(models);
            return;
        }
        HashMap<String, List> modelsByDeploymentIds = new HashMap<String, List>();
        for (Model model : models) {
            assert (model instanceof ElasticsearchInternalModel);
            if (model instanceof ElasticsearchInternalModel) {
                ElasticsearchInternalModel esModel = (ElasticsearchInternalModel)model;
                modelsByDeploymentIds.merge(esModel.mlNodeDeploymentId(), new ArrayList<ElasticsearchInternalModel>(List.of(esModel)), (a, b) -> {
                    a.addAll(b);
                    return a;
                });
                continue;
            }
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot update model [{}] as it is not an Elasticsearch service model", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{model.getInferenceEntityId()})));
            return;
        }
        String deploymentIds = String.join((CharSequence)",", modelsByDeploymentIds.keySet());
        this.client.execute((ActionType)GetDeploymentStatsAction.INSTANCE, (ActionRequest)new GetDeploymentStatsAction.Request(deploymentIds), ActionListener.wrap(stats -> {
            for (AssignmentStats deploymentStats : stats.getStats().results()) {
                List modelsForDeploymentId = (List)modelsByDeploymentIds.get(deploymentStats.getDeploymentId());
                modelsForDeploymentId.forEach(model -> model.updateNumAllocations(deploymentStats.getNumberOfAllocations()));
            }
            ArrayList updatedModels = new ArrayList();
            modelsByDeploymentIds.values().forEach(updatedModels::addAll);
            listener.onResponse(updatedModels);
        }, e -> {
            logger.warn("Get deployment stats failed, cannot update the endpoint's number of allocations", (Throwable)e);
            listener.onResponse((Object)models);
        }));
    }

    public void defaultConfigs(ActionListener<List<Model>> defaultsListener) {
        this.preferredModelVariantFn.accept(defaultsListener.delegateFailureAndWrap((delegate, preferredModelVariant) -> {
            if (BaseElasticsearchInternalService.PreferredModelVariant.LINUX_X86_OPTIMIZED.equals(preferredModelVariant)) {
                defaultsListener.onResponse(this.defaultConfigsLinuxOptimized());
            } else {
                defaultsListener.onResponse(this.defaultConfigsPlatfromAgnostic());
            }
        }));
    }

    private List<Model> defaultConfigsLinuxOptimized() {
        return this.defaultConfigs(true);
    }

    private List<Model> defaultConfigsPlatfromAgnostic() {
        return this.defaultConfigs(false);
    }

    private List<Model> defaultConfigs(boolean useLinuxOptimizedModel) {
        ElserInternalModel defaultElser = new ElserInternalModel(DEFAULT_ELSER_ID, TaskType.SPARSE_EMBEDDING, NAME, ElserInternalServiceSettings.defaultEndpointSettings(useLinuxOptimizedModel), ElserMlNodeTaskSettings.DEFAULT, (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS);
        MultilingualE5SmallModel defaultE5 = new MultilingualE5SmallModel(DEFAULT_E5_ID, TaskType.TEXT_EMBEDDING, NAME, MultilingualE5SmallInternalServiceSettings.defaultEndpointSettings(useLinuxOptimizedModel), (ChunkingSettings)ChunkingSettingsBuilder.DEFAULT_SETTINGS);
        ElasticRerankerModel defaultRerank = new ElasticRerankerModel(DEFAULT_RERANK_ID, TaskType.RERANK, NAME, ElasticRerankerServiceSettings.defaultEndpointSettings(), RerankTaskSettings.DEFAULT_SETTINGS);
        return List.of(defaultElser, defaultE5, defaultRerank);
    }

    @Override
    boolean isDefaultId(String inferenceId) {
        return DEFAULT_ELSER_ID.equals(inferenceId) || DEFAULT_E5_ID.equals(inferenceId) || DEFAULT_RERANK_ID.equals(inferenceId);
    }

    static EmbeddingRequestChunker.EmbeddingType embeddingTypeFromTaskTypeAndSettings(TaskType taskType, ElasticsearchInternalServiceSettings serviceSettings) {
        return switch (taskType) {
            case TaskType.SPARSE_EMBEDDING -> EmbeddingRequestChunker.EmbeddingType.SPARSE;
            case TaskType.TEXT_EMBEDDING -> {
                if (serviceSettings.elementType() == null) {
                    yield EmbeddingRequestChunker.EmbeddingType.FLOAT;
                }
                yield EmbeddingRequestChunker.EmbeddingType.fromDenseVectorElementType(serviceSettings.elementType());
            }
            default -> throw new ElasticsearchStatusException("Chunking is not supported for task type [{}]", RestStatus.BAD_REQUEST, new Object[]{taskType});
        };
    }

    private void validateAgainstDeployment(String modelId, String deploymentId, TaskType taskType, ActionListener<ElasticsearchInternalServiceSettings.Builder> listener) {
        this.getDeployment(deploymentId, (ActionListener<Optional<AssignmentStats>>)listener.delegateFailureAndWrap((l, response) -> {
            if (response.isPresent()) {
                if (modelId != null && !modelId.equals(((AssignmentStats)response.get()).getModelId())) {
                    listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Deployment [{}] uses model [{}] which does not match the model [{}] in the request.", RestStatus.BAD_REQUEST, new Object[]{deploymentId, ((AssignmentStats)response.get()).getModelId(), modelId})));
                    return;
                }
                ElasticsearchInternalServiceSettings.Builder updatedSettings = new ElasticsearchInternalServiceSettings.Builder().setNumAllocations(((AssignmentStats)response.get()).getNumberOfAllocations()).setNumThreads(((AssignmentStats)response.get()).getThreadsPerAllocation()).setAdaptiveAllocationsSettings(((AssignmentStats)response.get()).getAdaptiveAllocationsSettings()).setDeploymentId(deploymentId).setModelId(((AssignmentStats)response.get()).getModelId());
                this.checkTaskTypeForMlNodeModel(((AssignmentStats)response.get()).getModelId(), taskType, (ActionListener<Boolean>)l.delegateFailureAndWrap((l2, compatibleTaskType) -> l2.onResponse((Object)updatedSettings)));
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot find deployment [{}]", RestStatus.NOT_FOUND, new Object[]{deploymentId})));
            }
        }));
    }

    private void getDeployment(String deploymentId, ActionListener<Optional<AssignmentStats>> listener) {
        this.client.execute((ActionType)GetDeploymentStatsAction.INSTANCE, (ActionRequest)new GetDeploymentStatsAction.Request(deploymentId), listener.delegateFailureAndWrap((l, response) -> l.onResponse(response.getStats().results().stream().filter(s -> s.getDeploymentId() != null && s.getDeploymentId().equals(deploymentId)).findFirst())));
    }

    private void checkTaskTypeForMlNodeModel(String modelId, TaskType taskType, ActionListener<Boolean> listener) {
        this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)new GetTrainedModelsAction.Request(modelId), listener.delegateFailureAndWrap((l, response) -> {
            if (response.getResources().results().isEmpty()) {
                l.onFailure((Exception)new IllegalStateException("this shouldn't happen"));
                return;
            }
            InferenceConfig inferenceConfig = ((TrainedModelConfig)response.getResources().results().get(0)).getInferenceConfig();
            ElasticsearchInternalService.throwIfUnsupportedTaskType(modelId, taskType, inferenceConfig);
            l.onResponse((Object)Boolean.TRUE);
        }));
    }

    static void throwIfUnsupportedTaskType(String modelId, TaskType taskType, InferenceConfig inferenceConfig) {
        TaskType deploymentTaskType = ElasticsearchInternalService.inferenceConfigToTaskType(inferenceConfig);
        if (deploymentTaskType == null) {
            throw new ElasticsearchStatusException("Deployed model [{}] has type [{}] which does not map to any supported task types", RestStatus.BAD_REQUEST, new Object[]{modelId, inferenceConfig.getWriteableName()});
        }
        if (deploymentTaskType != taskType) {
            throw new ElasticsearchStatusException("Deployed model [{}] with type [{}] does not match the requested task type [{}]", RestStatus.BAD_REQUEST, new Object[]{modelId, inferenceConfig.getWriteableName(), taskType});
        }
    }

    static TaskType inferenceConfigToTaskType(InferenceConfig config) {
        if (config instanceof TextExpansionConfig) {
            return TaskType.SPARSE_EMBEDDING;
        }
        if (config instanceof TextEmbeddingConfig) {
            return TaskType.TEXT_EMBEDDING;
        }
        if (config instanceof TextSimilarityConfig) {
            return TaskType.RERANK;
        }
        return null;
    }

    private /* synthetic */ void lambda$parseRequestConfig$3(String inferenceEntityId, TaskType taskType, Map config, Map serviceSettingsMap, String serviceName, ChunkingSettings chunkingSettings, ActionListener modelListener, ActionListener delegate, BaseElasticsearchInternalService.PreferredModelVariant preferredModelVariant) throws Exception {
        this.elserCase(inferenceEntityId, taskType, config, preferredModelVariant, serviceSettingsMap, OLD_ELSER_SERVICE_NAME.equals(serviceName), chunkingSettings, (ActionListener<Model>)modelListener);
    }

    private /* synthetic */ void lambda$parseRequestConfig$2(String inferenceEntityId, TaskType taskType, Map config, Map serviceSettingsMap, ChunkingSettings chunkingSettings, ActionListener modelListener, ActionListener delegate, BaseElasticsearchInternalService.PreferredModelVariant preferredModelVariant) throws Exception {
        this.e5Case(inferenceEntityId, taskType, config, preferredModelVariant, serviceSettingsMap, chunkingSettings, (ActionListener<Model>)modelListener);
    }

    private /* synthetic */ void lambda$parseRequestConfig$1(String inferenceEntityId, TaskType taskType, Map config, Map serviceSettingsMap, ChunkingSettings chunkingSettings, ActionListener modelListener, ActionListener delegate, BaseElasticsearchInternalService.PreferredModelVariant preferredModelVariant) throws Exception {
        this.elserCase(inferenceEntityId, taskType, config, preferredModelVariant, serviceSettingsMap, true, chunkingSettings, (ActionListener<Model>)modelListener);
    }

    private static /* synthetic */ void lambda$parseRequestConfig$0(String inferenceEntityId, TaskType taskType, ChunkingSettings chunkingSettings, ActionListener l, ElasticsearchInternalServiceSettings.Builder settings) throws Exception {
        l.onResponse((Object)new ElasticDeployedModel(inferenceEntityId, taskType, NAME, settings.build(), chunkingSettings));
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("model_id", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The name of the model to use for the inference task.").setLabel("Model ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("num_allocations", new SettingsConfiguration.Builder(supportedTaskTypes).setDefaultValue((Object)1).setDescription("The total number of allocations this model is assigned across machine learning nodes.").setLabel("Number Allocations").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(true)).setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.put("num_threads", new SettingsConfiguration.Builder(supportedTaskTypes).setDefaultValue((Object)2).setDescription("Sets the number of threads used by each model allocation during inference.").setLabel("Number Threads").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build());
            return new InferenceServiceConfiguration.Builder().setService(ElasticsearchInternalService.NAME).setName(ElasticsearchInternalService.SERVICE_NAME).setTaskTypes(supportedTaskTypes).setConfigurations(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }

    class BatchIterator {
        private static final int NUM_REQUESTS_INFLIGHT = 20;
        private final AtomicInteger index = new AtomicInteger();
        private final ElasticsearchInternalModel esModel;
        private final List<EmbeddingRequestChunker.BatchRequestAndListener> requestAndListeners;
        private final InputType inputType;
        private final TimeValue timeout;

        BatchIterator(ElasticsearchInternalModel esModel, InputType inputType, TimeValue timeout, List<EmbeddingRequestChunker.BatchRequestAndListener> requestAndListeners) {
            this.esModel = esModel;
            this.requestAndListeners = requestAndListeners;
            this.inputType = inputType;
            this.timeout = timeout;
        }

        void run() {
            ElasticsearchInternalService.this.inferenceExecutor.execute(() -> this.inferBatch(20, true));
        }

        private void inferBatch(int runAfterCount, boolean maybeDeploy) {
            int batchIndex = this.index.getAndIncrement();
            if (batchIndex >= this.requestAndListeners.size()) {
                return;
            }
            this.executeRequest(batchIndex, maybeDeploy, () -> {
                for (int i = 0; i < runAfterCount; ++i) {
                    ElasticsearchInternalService.this.inferenceExecutor.execute(() -> this.inferBatch(1, false));
                }
            });
        }

        private void executeRequest(int batchIndex, boolean maybeDeploy, Runnable runAfter) {
            EmbeddingRequestChunker.BatchRequestAndListener batch = this.requestAndListeners.get(batchIndex);
            InferModelAction.Request inferenceRequest = BaseElasticsearchInternalService.buildInferenceRequest(this.esModel.mlNodeDeploymentId(), (InferenceConfigUpdate)EmptyConfigUpdate.INSTANCE, batch.batch().inputs(), this.inputType, this.timeout);
            logger.trace("Executing batch index={}", (Object)batchIndex);
            ActionListener listener = batch.listener().delegateFailureAndWrap((l, inferenceResult) -> ElasticsearchInternalService.translateToChunkedResult(this.esModel.getTaskType(), inferenceResult.getInferenceResults(), (ActionListener<InferenceServiceResults>)l));
            if (runAfter != null) {
                listener = ActionListener.runAfter((ActionListener)listener, (Runnable)runAfter);
            }
            if (maybeDeploy) {
                listener = listener.delegateResponse((l, exception) -> ElasticsearchInternalService.this.maybeStartDeployment(this.esModel, (Exception)exception, inferenceRequest, (ActionListener<InferModelAction.Response>)l));
            }
            ElasticsearchInternalService.this.client.execute((ActionType)InferModelAction.INSTANCE, (ActionRequest)inferenceRequest, listener);
        }
    }
}

