/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.kql.parser;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.xpack.kql.parser.KqlBaseBaseVisitor;
import org.elasticsearch.xpack.kql.parser.KqlBaseParser;
import org.elasticsearch.xpack.kql.parser.KqlParsingContext;
import org.elasticsearch.xpack.kql.parser.KqlParsingException;
import org.elasticsearch.xpack.kql.parser.ParserUtils;

class KqlAstBuilder
extends KqlBaseBaseVisitor<QueryBuilder> {
    private final KqlParsingContext kqlParsingContext;

    KqlAstBuilder(KqlParsingContext kqlParsingContext) {
        this.kqlParsingContext = kqlParsingContext;
    }

    public QueryBuilder toQueryBuilder(ParserRuleContext ctx) {
        if (ctx instanceof KqlBaseParser.TopLevelQueryContext) {
            KqlBaseParser.TopLevelQueryContext topLeveQueryContext = (KqlBaseParser.TopLevelQueryContext)ctx;
            if (topLeveQueryContext.query() != null) {
                return ParserUtils.typedParsing(this, topLeveQueryContext.query(), QueryBuilder.class);
            }
            return new MatchAllQueryBuilder();
        }
        throw new IllegalArgumentException("context should be of type TopLevelQueryContext");
    }

    @Override
    public QueryBuilder visitBooleanQuery(KqlBaseParser.BooleanQueryContext ctx) {
        assert (ctx.operator != null);
        return KqlAstBuilder.isAndQuery(ctx) ? this.visitAndBooleanQuery(ctx.query()) : this.visitOrBooleanQuery(ctx.query());
    }

    public QueryBuilder visitAndBooleanQuery(List<? extends ParserRuleContext> clauses) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        for (ParserRuleContext parserRuleContext : clauses) {
            if (KqlAstBuilder.isAndQuery(parserRuleContext)) {
                ParserUtils.typedParsing(this, parserRuleContext, BoolQueryBuilder.class).must().forEach(arg_0 -> ((BoolQueryBuilder)builder).must(arg_0));
                continue;
            }
            builder.must(ParserUtils.typedParsing(this, parserRuleContext, QueryBuilder.class));
        }
        return this.rewriteConjunctionQuery(builder);
    }

    public QueryBuilder visitOrBooleanQuery(List<? extends ParserRuleContext> clauses) {
        BoolQueryBuilder builder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        for (ParserRuleContext parserRuleContext : clauses) {
            if (KqlAstBuilder.isOrQuery(parserRuleContext)) {
                ParserUtils.typedParsing(this, parserRuleContext, BoolQueryBuilder.class).should().forEach(arg_0 -> ((BoolQueryBuilder)builder).should(arg_0));
                continue;
            }
            builder.should(ParserUtils.typedParsing(this, parserRuleContext, QueryBuilder.class));
        }
        return this.rewriteDisjunctionQuery(builder);
    }

    @Override
    public QueryBuilder visitNotQuery(KqlBaseParser.NotQueryContext ctx) {
        return QueryBuilders.boolQuery().mustNot(ParserUtils.typedParsing(this, ctx.simpleQuery(), QueryBuilder.class));
    }

    @Override
    public QueryBuilder visitParenthesizedQuery(KqlBaseParser.ParenthesizedQueryContext ctx) {
        return ParserUtils.typedParsing(this, ctx.query(), QueryBuilder.class);
    }

    @Override
    public QueryBuilder visitNestedQuery(KqlBaseParser.NestedQueryContext ctx) {
        String nestedFieldName = ParserUtils.extractText(ctx.fieldName());
        if (!this.kqlParsingContext.isNestedField(nestedFieldName)) {
            throw new KqlParsingException("[{}] is not a valid nested field name.", ctx.start.getLine(), ctx.start.getCharPositionInLine(), nestedFieldName);
        }
        QueryBuilder subQuery = this.kqlParsingContext.withNestedPath(nestedFieldName, () -> ParserUtils.typedParsing(this, ctx.nestedSubQuery(), QueryBuilder.class));
        if (subQuery instanceof MatchNoneQueryBuilder) {
            return subQuery;
        }
        return this.wrapWithNestedQuery(nestedFieldName, (QueryBuilder)QueryBuilders.nestedQuery((String)this.kqlParsingContext.fullFieldName(nestedFieldName), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None));
    }

    @Override
    public QueryBuilder visitBooleanNestedQuery(KqlBaseParser.BooleanNestedQueryContext ctx) {
        assert (ctx.operator != null);
        return KqlAstBuilder.isAndQuery(ctx) ? this.visitAndBooleanQuery(ctx.nestedSubQuery()) : this.visitOrBooleanQuery(ctx.nestedSubQuery());
    }

    @Override
    public QueryBuilder visitNestedParenthesizedQuery(KqlBaseParser.NestedParenthesizedQueryContext ctx) {
        return ParserUtils.typedParsing(this, ctx.nestedSubQuery(), QueryBuilder.class);
    }

    @Override
    public QueryBuilder visitMatchAllQuery(KqlBaseParser.MatchAllQueryContext ctx) {
        return new MatchAllQueryBuilder();
    }

    @Override
    public QueryBuilder visitExistsQuery(KqlBaseParser.ExistsQueryContext ctx) {
        assert (ctx.fieldName() != null);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        this.withFields(ctx.fieldName(), (fieldName, mappedFieldType) -> {
            if (!KqlParsingContext.isRuntimeField(mappedFieldType)) {
                boolQueryBuilder.should(this.wrapWithNestedQuery((String)fieldName, (QueryBuilder)QueryBuilders.existsQuery((String)fieldName)));
            }
        });
        return this.rewriteDisjunctionQuery(boolQueryBuilder);
    }

    @Override
    public QueryBuilder visitRangeQuery(KqlBaseParser.RangeQueryContext ctx) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        String queryText = ParserUtils.extractText(ctx.rangeQueryValue());
        BiFunction<RangeQueryBuilder, String, RangeQueryBuilder> rangeOperation = this.rangeOperation(ctx.operator);
        this.withFields(ctx.fieldName(), (fieldName, mappedFieldType) -> {
            RangeQueryBuilder rangeQuery = (RangeQueryBuilder)rangeOperation.apply(QueryBuilders.rangeQuery((String)fieldName), queryText);
            if (this.kqlParsingContext.timeZone() != null) {
                rangeQuery.timeZone(this.kqlParsingContext.timeZone().getId());
            }
            boolQueryBuilder.should(this.wrapWithNestedQuery((String)fieldName, (QueryBuilder)rangeQuery));
        });
        return this.rewriteDisjunctionQuery(boolQueryBuilder);
    }

    @Override
    public QueryBuilder visitFieldLessQuery(KqlBaseParser.FieldLessQueryContext ctx) {
        String queryText = ParserUtils.extractText(ctx.fieldQueryValue());
        if (ParserUtils.hasWildcard(ctx.fieldQueryValue())) {
            QueryStringQueryBuilder queryString = QueryBuilders.queryStringQuery((String)ParserUtils.escapeLuceneQueryString(queryText, true));
            if (this.kqlParsingContext.defaultField() != null) {
                queryString.defaultField(this.kqlParsingContext.defaultField());
            }
            return queryString;
        }
        boolean isPhraseMatch = ctx.fieldQueryValue().QUOTED_STRING() != null;
        MultiMatchQueryBuilder multiMatchQuery = QueryBuilders.multiMatchQuery((Object)queryText, (String[])new String[0]).type(isPhraseMatch ? MultiMatchQueryBuilder.Type.PHRASE : MultiMatchQueryBuilder.Type.BEST_FIELDS).lenient(true);
        if (this.kqlParsingContext.defaultField() != null) {
            this.kqlParsingContext.resolveDefaultFieldNames().stream().filter(this.kqlParsingContext::isSearchableField).forEach(arg_0 -> ((MultiMatchQueryBuilder)multiMatchQuery).field(arg_0));
        }
        return multiMatchQuery;
    }

    @Override
    public QueryBuilder visitFieldQuery(KqlBaseParser.FieldQueryContext ctx) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().minimumShouldMatch(1);
        String queryText = ParserUtils.extractText(ctx.fieldQueryValue());
        boolean hasWildcard = ParserUtils.hasWildcard(ctx.fieldQueryValue());
        this.withFields(ctx.fieldName(), (fieldName, mappedFieldType) -> {
            Object fieldQuery = null;
            if (hasWildcard && KqlParsingContext.isKeywordField(mappedFieldType)) {
                fieldQuery = QueryBuilders.wildcardQuery((String)fieldName, (String)queryText).caseInsensitive(this.kqlParsingContext.caseInsensitive());
            } else if (hasWildcard) {
                fieldQuery = QueryBuilders.queryStringQuery((String)ParserUtils.escapeLuceneQueryString(queryText, true)).field(fieldName);
            } else if (KqlParsingContext.isDateField(mappedFieldType)) {
                RangeQueryBuilder rangeFieldQuery = QueryBuilders.rangeQuery((String)fieldName).gte((Object)queryText).lte((Object)queryText);
                if (this.kqlParsingContext.timeZone() != null) {
                    rangeFieldQuery.timeZone(this.kqlParsingContext.timeZone().getId());
                }
                fieldQuery = rangeFieldQuery;
            } else {
                fieldQuery = KqlParsingContext.isKeywordField(mappedFieldType) ? QueryBuilders.termQuery((String)fieldName, (String)queryText).caseInsensitive(this.kqlParsingContext.caseInsensitive()) : (ctx.fieldQueryValue().QUOTED_STRING() != null ? QueryBuilders.matchPhraseQuery((String)fieldName, (Object)queryText) : QueryBuilders.matchQuery((String)fieldName, (Object)queryText));
            }
            if (fieldQuery != null) {
                boolQueryBuilder.should(this.wrapWithNestedQuery((String)fieldName, (QueryBuilder)fieldQuery));
            }
        });
        return this.rewriteDisjunctionQuery(boolQueryBuilder);
    }

    private static boolean isAndQuery(ParserRuleContext ctx) {
        ParserRuleContext parserRuleContext = ctx;
        Objects.requireNonNull(parserRuleContext);
        ParserRuleContext parserRuleContext2 = parserRuleContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KqlBaseParser.BooleanQueryContext.class, KqlBaseParser.BooleanNestedQueryContext.class}, (Object)parserRuleContext2, n)) {
            case 0 -> {
                KqlBaseParser.BooleanQueryContext booleanQueryCtx = (KqlBaseParser.BooleanQueryContext)parserRuleContext2;
                if (booleanQueryCtx.operator.getType() == 2) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                KqlBaseParser.BooleanNestedQueryContext booleanNestedCtx = (KqlBaseParser.BooleanNestedQueryContext)parserRuleContext2;
                if (booleanNestedCtx.operator.getType() == 2) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isOrQuery(ParserRuleContext ctx) {
        ParserRuleContext parserRuleContext = ctx;
        Objects.requireNonNull(parserRuleContext);
        ParserRuleContext parserRuleContext2 = parserRuleContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KqlBaseParser.BooleanQueryContext.class, KqlBaseParser.BooleanNestedQueryContext.class}, (Object)parserRuleContext2, n)) {
            case 0 -> {
                KqlBaseParser.BooleanQueryContext booleanQueryCtx = (KqlBaseParser.BooleanQueryContext)parserRuleContext2;
                if (booleanQueryCtx.operator.getType() == 3) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                KqlBaseParser.BooleanNestedQueryContext booleanNestedCtx = (KqlBaseParser.BooleanNestedQueryContext)parserRuleContext2;
                if (booleanNestedCtx.operator.getType() == 3) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void withFields(KqlBaseParser.FieldNameContext ctx, BiConsumer<String, MappedFieldType> fieldConsummer) {
        assert (ctx != null) : "Field ctx cannot be null";
        String fieldNamePattern = ParserUtils.extractText(ctx);
        Set<String> fieldNames = this.kqlParsingContext.resolveFieldNames(fieldNamePattern);
        if (ctx.value.getType() == 15 && Regex.isSimpleMatchPattern((String)fieldNamePattern)) {
            return;
        }
        if (ctx.value.getType() == 15) assert (fieldNames.size() < 2) : "expecting only one matching field";
        fieldNames.forEach(fieldName -> {
            MappedFieldType fieldType = this.kqlParsingContext.fieldType((String)fieldName);
            if (KqlParsingContext.isSearchableField(fieldName, fieldType)) {
                fieldConsummer.accept((String)fieldName, fieldType);
            }
        });
    }

    private QueryBuilder rewriteDisjunctionQuery(BoolQueryBuilder boolQueryBuilder) {
        assert (boolQueryBuilder.must().isEmpty() && boolQueryBuilder.filter().isEmpty() && boolQueryBuilder.mustNot().isEmpty());
        if (boolQueryBuilder.should().isEmpty()) {
            return new MatchNoneQueryBuilder();
        }
        return boolQueryBuilder.should().size() == 1 ? (QueryBuilder)boolQueryBuilder.should().getFirst() : boolQueryBuilder;
    }

    private QueryBuilder rewriteConjunctionQuery(BoolQueryBuilder boolQueryBuilder) {
        assert (boolQueryBuilder.should().isEmpty() && boolQueryBuilder.filter().isEmpty() && boolQueryBuilder.mustNot().isEmpty());
        if (boolQueryBuilder.must().isEmpty()) {
            return new MatchNoneQueryBuilder();
        }
        return boolQueryBuilder.must().size() == 1 ? (QueryBuilder)boolQueryBuilder.must().getFirst() : boolQueryBuilder;
    }

    private BiFunction<RangeQueryBuilder, String, RangeQueryBuilder> rangeOperation(Token operator) {
        return switch (operator.getType()) {
            case 6 -> RangeQueryBuilder::lt;
            case 7 -> RangeQueryBuilder::lte;
            case 8 -> RangeQueryBuilder::gt;
            case 9 -> RangeQueryBuilder::gte;
            default -> throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)"Invalid range operator {}\"", (Object[])new Object[]{operator.getText()}));
        };
    }

    private QueryBuilder wrapWithNestedQuery(String fieldName, QueryBuilder query) {
        String nestedPath = this.kqlParsingContext.nestedPath(fieldName);
        if (nestedPath == null || nestedPath.equals(this.kqlParsingContext.currentNestedPath())) {
            return query;
        }
        return this.wrapWithNestedQuery(nestedPath, (QueryBuilder)QueryBuilders.nestedQuery((String)nestedPath, (QueryBuilder)query, (ScoreMode)ScoreMode.None));
    }
}

