/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.tdigest.AbstractTDigest;
import org.elasticsearch.tdigest.arrays.TDigestDoubleArray;

public class Dist {
    private static double cdf(double x, int length, Function<Integer, Double> elementGetter) {
        double right;
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            double value = elementGetter.apply(0);
            if (x < value) {
                return 0.0;
            }
            if (x > value) {
                return 1.0;
            }
            return 0.5;
        }
        if (Double.compare(x, elementGetter.apply(0)) < 0) {
            return 0.0;
        }
        if (Double.compare(x, elementGetter.apply(0)) == 0) {
            double dw = 0.0;
            for (int i = 0; i < length && Double.compare(elementGetter.apply(i), x) == 0; ++i) {
                dw += 1.0;
            }
            return dw / 2.0 / (double)length;
        }
        if (x > elementGetter.apply(length - 1)) {
            return 1.0;
        }
        if (x == elementGetter.apply(length - 1)) {
            double dw = 0.0;
            for (int i = length - 1; i >= 0 && Double.compare(elementGetter.apply(i), x) == 0; --i) {
                dw += 1.0;
            }
            return ((double)length - dw / 2.0) / (double)length;
        }
        double left = (elementGetter.apply(1) - elementGetter.apply(0)) / 2.0;
        double weightSoFar = 0.0;
        for (int i = 0; i < length - 1; ++i) {
            right = (elementGetter.apply(i + 1) - elementGetter.apply(i)) / 2.0;
            if (x < elementGetter.apply(i) + right) {
                double value = (weightSoFar + AbstractTDigest.interpolate(x, elementGetter.apply(i) - left, elementGetter.apply(i) + right)) / (double)length;
                return Math.max(value, 0.0);
            }
            weightSoFar += 1.0;
            left = right;
        }
        int lastOffset = length - 1;
        right = (elementGetter.apply(lastOffset) - elementGetter.apply(lastOffset - 1)) / 2.0;
        if (x < elementGetter.apply(lastOffset) + right) {
            return (weightSoFar + AbstractTDigest.interpolate(x, elementGetter.apply(lastOffset) - right, elementGetter.apply(lastOffset) + right)) / (double)length;
        }
        return 1.0;
    }

    public static double cdf(double x, double[] data) {
        return Dist.cdf(x, data.length, i -> data[i]);
    }

    public static double cdf(double x, List<Double> data) {
        return Dist.cdf(x, data.size(), data::get);
    }

    public static double cdf(double x, TDigestDoubleArray data) {
        return Dist.cdf(x, data.size(), data::get);
    }

    private static double quantile(double q, int length, Function<Integer, Double> elementGetter) {
        if (length == 0) {
            return Double.NaN;
        }
        double index = q * (double)(length - 1);
        int low_index = (int)Math.floor(index);
        int high_index = low_index + 1;
        double weight = index - (double)low_index;
        if (index <= 0.0) {
            low_index = 0;
            high_index = 0;
            weight = 0.0;
        }
        if (index >= (double)(length - 1)) {
            low_index = length - 1;
            high_index = length - 1;
            weight = 0.0;
        }
        double low_value = elementGetter.apply(low_index);
        double high_value = elementGetter.apply(high_index);
        return low_value + weight * (high_value - low_value);
    }

    public static double quantile(double q, double[] data) {
        return Dist.quantile(q, data.length, i -> data[i]);
    }

    public static double quantile(double q, List<Double> data) {
        return Dist.quantile(q, data.size(), data::get);
    }

    public static double quantile(double q, TDigestDoubleArray data) {
        return Dist.quantile(q, data.size(), data::get);
    }
}

