/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.persistence;

import java.util.Objects;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.search.SearchHit;

public class SeqNoPrimaryTermAndIndex {
    private final long seqNo;
    private final long primaryTerm;
    private final String index;

    public static SeqNoPrimaryTermAndIndex fromSearchHit(SearchHit hit) {
        return new SeqNoPrimaryTermAndIndex(hit.getSeqNo(), hit.getPrimaryTerm(), hit.getIndex());
    }

    public static SeqNoPrimaryTermAndIndex fromIndexResponse(DocWriteResponse response) {
        return new SeqNoPrimaryTermAndIndex(response.getSeqNo(), response.getPrimaryTerm(), response.getIndex());
    }

    public SeqNoPrimaryTermAndIndex(long seqNo, long primaryTerm, String index) {
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.index = index;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getIndex() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hash(this.seqNo, this.primaryTerm, this.index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SeqNoPrimaryTermAndIndex other = (SeqNoPrimaryTermAndIndex)obj;
        return Objects.equals(this.seqNo, other.seqNo) && Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.index, other.index);
    }

    public String toString() {
        return "{seqNo=" + this.seqNo + ",primaryTerm=" + this.primaryTerm + ",index=" + this.index + "}";
    }
}

