/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.LegacyTiersDetection;
import org.elasticsearch.xpack.deprecation.ResourceDeprecationChecker;
import org.elasticsearch.xpack.deprecation.TransportDeprecationInfoAction;

public class IlmPolicyDeprecationChecker
implements ResourceDeprecationChecker {
    public static final String NAME = "ilm_policies";
    private final List<Function<LifecyclePolicy, DeprecationIssue>> checks = List.of(this::checkLegacyTiers, this::checkFrozenAction);

    @Override
    public Map<String, List<DeprecationIssue>> check(ClusterState clusterState, DeprecationInfoAction.Request request, TransportDeprecationInfoAction.PrecomputedData precomputedData) {
        return this.check(clusterState);
    }

    Map<String, List<DeprecationIssue>> check(ClusterState clusterState) {
        IndexLifecycleMetadata lifecycleMetadata = (IndexLifecycleMetadata)clusterState.metadata().custom("index_lifecycle");
        if (lifecycleMetadata == null || lifecycleMetadata.getPolicyMetadatas().isEmpty()) {
            return Map.of();
        }
        HashMap<String, List<DeprecationIssue>> issues = new HashMap<String, List<DeprecationIssue>>();
        for (Map.Entry entry : lifecycleMetadata.getPolicyMetadatas().entrySet()) {
            String name = (String)entry.getKey();
            LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)entry.getValue();
            List<DeprecationIssue> issuesForSinglePolicy = this.checks.stream().map(c -> (DeprecationIssue)c.apply(policyMetadata.getPolicy())).filter(Objects::nonNull).toList();
            if (issuesForSinglePolicy.isEmpty()) continue;
            issues.put(name, issuesForSinglePolicy);
        }
        return issues.isEmpty() ? Map.of() : issues;
    }

    private DeprecationIssue checkLegacyTiers(LifecyclePolicy policy) {
        for (Phase phase : policy.getPhases().values()) {
            AllocateAction allocateAction = (AllocateAction)phase.getActions().get("allocate");
            if (allocateAction == null || !LegacyTiersDetection.containsDeprecatedFilteredAllocationConfig(allocateAction.getExclude()) && !LegacyTiersDetection.containsDeprecatedFilteredAllocationConfig(allocateAction.getInclude()) && !LegacyTiersDetection.containsDeprecatedFilteredAllocationConfig(allocateAction.getRequire())) continue;
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Configuring tiers via filtered allocation is not recommended.", "https://ela.st/migrate-to-tiers", "One or more of your ILM policies is configuring tiers via the 'data' node attribute. This is typically used to create a hot/warm or tiered architecture, based on legacy guidelines. Data tiers are a recommended replacement for tiered architecture clusters.", false, null);
        }
        return null;
    }

    private DeprecationIssue checkFrozenAction(LifecyclePolicy policy) {
        for (Phase phase : policy.getPhases().values()) {
            if (!phase.getActions().containsKey("freeze")) continue;
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "ILM policy [" + policy.getName() + "] contains the action 'freeze' that is deprecated and will be removed in a future version.", "https://www.elastic.co/guide/en/elasticsearch/reference/master/frozen-indices.html", "This action is already a noop so it can be safely removed, because frozen indices no longer offer any advantages. Consider cold or frozen tiers in place of frozen indices.", false, null);
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

