/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geometry;

import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.WellKnownText;

public class Point
implements Geometry {
    public static final Point EMPTY = new Point();
    private final double y;
    private final double x;
    private final double z;
    private final boolean empty;

    private Point() {
        this.y = 0.0;
        this.x = 0.0;
        this.z = Double.NaN;
        this.empty = true;
    }

    public Point(double x, double y) {
        this(x, y, Double.NaN);
    }

    public Point(double x, double y, double z) {
        this.y = y;
        this.x = x;
        this.z = z;
        this.empty = false;
    }

    @Override
    public ShapeType type() {
        return ShapeType.POINT;
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public double getLat() {
        return this.y;
    }

    public double getLon() {
        return this.x;
    }

    public double getAlt() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (point.empty != this.empty) {
            return false;
        }
        if (Double.compare(point.y, this.y) != 0) {
            return false;
        }
        if (Double.compare(point.x, this.x) != 0) {
            return false;
        }
        return Double.compare(point.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.y);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean hasZ() {
        return !Double.isNaN(this.z);
    }

    public String toString() {
        return WellKnownText.toWKT(this);
    }
}

