/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import java.util.stream.IntStream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.aggregation.Aggregator;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.FromPartialAggregatorFunction;
import org.elasticsearch.compute.aggregation.FromPartialGroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class FromPartial
extends AggregateFunction
implements ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "FromPartial", FromPartial::new);
    private final Expression function;

    public FromPartial(Source source, Expression field, Expression function) {
        this(source, field, (Expression)Literal.TRUE, function);
    }

    public FromPartial(Source source, Expression field, Expression filter, Expression function) {
        super(source, field, filter, List.of(function));
        this.function = function;
    }

    private FromPartial(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)(in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? (Expression)in.readNamedWriteable(Expression.class) : Literal.TRUE), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0) ? (Expression)in.readNamedWriteableCollectionAsList(Expression.class).get(0) : (Expression)in.readNamedWriteable(Expression.class));
    }

    @Override
    protected void deprecatedWriteParams(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.function);
    }

    public String getWriteableName() {
        return FromPartial.ENTRY.name;
    }

    public Expression function() {
        return this.function;
    }

    public DataType dataType() {
        return this.function.dataType();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public AttributeSet references() {
        return this.field().references();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new FromPartial(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, FromPartial::new, (Object)this.field(), (Object)this.filter(), (Object)this.function);
    }

    @Override
    public FromPartial withFilter(Expression filter) {
        return new FromPartial(this.source(), this.field(), filter, this.function);
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        final AggregatorFunctionSupplier supplier = ((ToAggregator)this.function).supplier();
        return new AggregatorFunctionSupplier(){

            public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
                return FromPartialAggregatorFunction.intermediateStateDesc();
            }

            public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
                return FromPartialGroupingAggregatorFunction.intermediateStateDesc();
            }

            public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
                assert (false) : "aggregatorFactory() is override";
                throw new UnsupportedOperationException();
            }

            public GroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
                assert (false) : "groupingAggregatorFactory() is override";
                throw new UnsupportedOperationException();
            }

            public Aggregator.Factory aggregatorFactory(final AggregatorMode mode, List<Integer> channels) {
                if (channels.size() != 1) {
                    assert (false) : "from_partial aggregation requires exactly one input channel; got " + String.valueOf(channels);
                    throw new IllegalArgumentException("from_partial aggregation requires exactly one input channel; got " + String.valueOf(channels));
                }
                final int inputChannel = channels.get(0);
                final List<Integer> intermediateChannels = IntStream.range(0, supplier.nonGroupingIntermediateStateDesc().size()).boxed().toList();
                return new Aggregator.Factory(){

                    public Aggregator apply(DriverContext driverContext) {
                        GroupingAggregatorFunction groupingAggregator = supplier.groupingAggregator(driverContext, intermediateChannels);
                        return new Aggregator((AggregatorFunction)new FromPartialAggregatorFunction(driverContext, groupingAggregator, inputChannel), mode);
                    }

                    public String describe() {
                        return "from_partial(" + supplier.describe() + ")";
                    }
                };
            }

            public GroupingAggregator.Factory groupingAggregatorFactory(final AggregatorMode mode, List<Integer> channels) {
                if (channels.size() != 1) {
                    assert (false) : "from_partial aggregation requires exactly one input channel; got " + String.valueOf(channels);
                    throw new IllegalArgumentException("from_partial aggregation requires exactly one input channel; got " + String.valueOf(channels));
                }
                final int inputChannel = channels.get(0);
                final List<Integer> intermediateChannels = IntStream.range(0, supplier.nonGroupingIntermediateStateDesc().size()).boxed().toList();
                return new GroupingAggregator.Factory(){

                    public GroupingAggregator apply(DriverContext driverContext) {
                        GroupingAggregatorFunction aggregator = supplier.groupingAggregator(driverContext, intermediateChannels);
                        return new GroupingAggregator((GroupingAggregatorFunction)new FromPartialGroupingAggregatorFunction(aggregator, inputChannel), mode);
                    }

                    public String describe() {
                        return "from_partial(" + supplier.describe() + ")";
                    }
                };
            }

            public String describe() {
                return "from_partial";
            }
        };
    }
}

