/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvZipEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class MvZip
extends EsqlScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvZip", MvZip::new);
    private final Expression mvLeft;
    private final Expression mvRight;
    private final Expression delim;
    private static final Literal COMMA = new Literal(Source.EMPTY, (Object)",", DataType.TEXT);

    @FunctionInfo(returnType={"keyword"}, description="Combines the values from two multivalued fields with a delimiter that joins them together.", examples={@Example(file="string", tag="mv_zip")})
    public MvZip(Source source, @Param(name="string1", type={"keyword", "text"}, description="Multivalue expression.") Expression mvLeft, @Param(name="string2", type={"keyword", "text"}, description="Multivalue expression.") Expression mvRight, @Param(name="delim", type={"keyword", "text"}, description="Delimiter. Optional; if omitted, `,` is used as a default delimiter.", optional=true) Expression delim) {
        super(source, delim == null ? Arrays.asList(mvLeft, mvRight, COMMA) : Arrays.asList(mvLeft, mvRight, delim));
        this.mvLeft = mvLeft;
        this.mvRight = mvRight;
        this.delim = delim;
    }

    private MvZip(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.mvLeft);
        out.writeNamedWriteable((NamedWriteable)this.mvRight);
        out.writeOptionalNamedWriteable((NamedWriteable)this.delim);
    }

    public String getWriteableName() {
        return MvZip.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.mvLeft, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString((Expression)this.mvRight, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.delim != null && (resolution = TypeResolutions.isString((Expression)this.delim, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).unresolved()) {
            return resolution;
        }
        return resolution;
    }

    public boolean foldable() {
        return this.mvLeft.foldable() && this.mvRight.foldable() && (this.delim == null || this.delim.foldable());
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new MvZipEvaluator.Factory(this.source(), toEvaluator.apply(this.mvLeft), toEvaluator.apply(this.mvRight), toEvaluator.apply((Expression)(this.delim == null ? COMMA : this.delim)));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvZip(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvZip::new, (Object)this.mvLeft, (Object)this.mvRight, (Object)this.delim);
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    private static void buildOneSide(BytesRefBlock.Builder builder, int start, int end, BytesRefBlock field, BytesRef fieldScratch) {
        builder.beginPositionEntry();
        for (int i = start; i < end; ++i) {
            builder.appendBytesRef(field.getBytesRef(i, fieldScratch));
        }
        builder.endPositionEntry();
    }

    static void process(BytesRefBlock.Builder builder, int position, BytesRefBlock leftField, BytesRefBlock rightField, BytesRef delim) {
        int rightIndex;
        int leftFieldValueCount = leftField.getValueCount(position);
        int rightFieldValueCount = rightField.getValueCount(position);
        int leftFirst = leftField.getFirstValueIndex(position);
        int rightFirst = rightField.getFirstValueIndex(position);
        BytesRef fieldScratch = new BytesRef();
        if (leftField.isNull(position)) {
            if (rightFieldValueCount == 1) {
                builder.appendBytesRef(rightField.getBytesRef(rightFirst, fieldScratch));
                return;
            }
            MvZip.buildOneSide(builder, rightFirst, rightFirst + rightFieldValueCount, rightField, fieldScratch);
            return;
        }
        if (rightField.isNull(position)) {
            if (leftFieldValueCount == 1) {
                builder.appendBytesRef(leftField.getBytesRef(leftFirst, fieldScratch));
                return;
            }
            MvZip.buildOneSide(builder, leftFirst, leftFirst + leftFieldValueCount, leftField, fieldScratch);
            return;
        }
        BytesRefBuilder work = new BytesRefBuilder();
        if (leftFieldValueCount == 1 && rightFieldValueCount == 1) {
            work.append(leftField.getBytesRef(leftFirst, fieldScratch));
            work.append(delim);
            work.append(rightField.getBytesRef(rightFirst, fieldScratch));
            builder.appendBytesRef(work.get());
            return;
        }
        int leftIndex = 0;
        builder.beginPositionEntry();
        for (rightIndex = 0; leftIndex < leftFieldValueCount && rightIndex < rightFieldValueCount; ++leftIndex, ++rightIndex) {
            work.clear();
            work.append(leftField.getBytesRef(leftIndex + leftFirst, fieldScratch));
            work.append(delim);
            work.append(rightField.getBytesRef(rightIndex + rightFirst, fieldScratch));
            builder.appendBytesRef(work.get());
        }
        while (leftIndex < leftFieldValueCount) {
            work.clear();
            work.append(leftField.getBytesRef(leftIndex + leftFirst, fieldScratch));
            builder.appendBytesRef(work.get());
            ++leftIndex;
        }
        while (rightIndex < rightFieldValueCount) {
            work.clear();
            work.append(rightField.getBytesRef(rightIndex + rightFirst, fieldScratch));
            builder.appendBytesRef(work.get());
            ++rightIndex;
        }
        builder.endPositionEntry();
    }

    Expression mvLeft() {
        return this.mvLeft;
    }

    Expression mvRight() {
        return this.mvRight;
    }

    Expression delim() {
        return this.delim;
    }
}

