/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Or;

public abstract class Predicates {
    public static List<Expression> splitAnd(Expression exp) {
        if (exp instanceof And) {
            And and = (And)exp;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.addAll(Predicates.splitAnd(and.left()));
            list.addAll(Predicates.splitAnd(and.right()));
            return list;
        }
        return Collections.singletonList(exp);
    }

    public static List<Expression> splitOr(Expression exp) {
        if (exp instanceof Or) {
            Or or = (Or)exp;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.addAll(Predicates.splitOr(or.left()));
            list.addAll(Predicates.splitOr(or.right()));
            return list;
        }
        return Collections.singletonList(exp);
    }

    public static Expression combineOr(List<Expression> exps) {
        return Predicates.combine(exps, (l, r) -> new Or(l.source(), (Expression)l, (Expression)r));
    }

    public static Expression combineAnd(List<Expression> exps) {
        return Predicates.combine(exps, (l, r) -> new And(l.source(), (Expression)l, (Expression)r));
    }

    private static Expression combine(List<Expression> exps, BiFunction<Expression, Expression, Expression> combiner) {
        if (exps.isEmpty()) {
            return null;
        }
        ArrayList<Expression> result = new ArrayList<Expression>(exps);
        while (result.size() > 1) {
            for (int i = 0; i < result.size() - 1; ++i) {
                Expression l = (Expression)result.get(i);
                Expression r = (Expression)result.remove(i + 1);
                result.set(i, combiner.apply(l, r));
            }
        }
        return (Expression)result.get(0);
    }

    public static List<Expression> inCommon(List<Expression> l, List<Expression> r) {
        ArrayList common = new ArrayList(Math.min(l.size(), r.size()));
        for (Expression lExp : l) {
            for (Expression rExp : r) {
                if (!lExp.semanticEquals(rExp)) continue;
                common.add(lExp);
            }
        }
        return common.isEmpty() ? Collections.emptyList() : common;
    }

    public static List<Expression> subtract(List<Expression> from, List<Expression> list) {
        ArrayList diff = new ArrayList(Math.min(from.size(), list.size()));
        for (Expression f : from) {
            boolean found = false;
            for (Expression l : list) {
                if (!f.semanticEquals(l)) continue;
                found = true;
                break;
            }
            if (found) continue;
            diff.add(f);
        }
        return diff.isEmpty() ? Collections.emptyList() : diff;
    }

    public static Tuple<Expression, List<Expression>> extractCommon(List<Expression> expressions) {
        List<Expression> common = null;
        ArrayList<List<Expression>> splitAnds = new ArrayList<List<Expression>>(expressions.size());
        for (Expression expression : expressions) {
            List<Expression> split2 = Predicates.splitAnd(expression);
            List<Expression> list = common = common == null ? split2 : Predicates.inCommon(split2, common);
            if (common.isEmpty()) {
                return Tuple.tuple(null, expressions);
            }
            splitAnds.add(split2);
        }
        ArrayList trimmed = new ArrayList(expressions.size());
        List<Expression> finalCommon = common;
        splitAnds.forEach(split -> {
            List<Expression> subtracted = Predicates.subtract(split, finalCommon);
            trimmed.add(subtracted.isEmpty() ? Literal.TRUE : Predicates.combineAnd(subtracted));
        });
        return Tuple.tuple((Object)Predicates.combineAnd(common), trimmed);
    }
}

