/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;

public class JoinTypes {
    public static JoinType INNER = CoreJoinType.INNER;
    public static JoinType LEFT = CoreJoinType.LEFT;
    public static JoinType RIGHT = CoreJoinType.RIGHT;
    public static JoinType FULL = CoreJoinType.FULL;
    public static JoinType CROSS = CoreJoinType.CROSS;
    private static Map<Byte, JoinType> JOIN_TYPES;

    private JoinTypes() {
    }

    public static JoinType readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        JoinType type = JOIN_TYPES.get(id);
        if (type == null) {
            throw new IllegalArgumentException("unsupported join [" + id + "]");
        }
        return type;
    }

    static {
        CoreJoinType[] types = CoreJoinType.values();
        JOIN_TYPES = Maps.newMapWithExpectedSize((int)types.length);
        for (CoreJoinType type : types) {
            JOIN_TYPES.put(type.id, type);
        }
    }

    private static enum CoreJoinType implements JoinType
    {
        INNER(1, "INNER"),
        LEFT(2, "LEFT OUTER"),
        RIGHT(3, "RIGHT OUTER"),
        FULL(4, "FULL OUTER"),
        CROSS(5, "CROSS");

        private final String name;
        private final byte id;

        private CoreJoinType(int id, String name) {
            this.id = (byte)id;
            this.name = name;
        }

        @Override
        public String joinName() {
            return this.name;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }
    }

    private static abstract class NaturalJoinType
    implements JoinType {
        private final JoinType joinType;

        private NaturalJoinType(JoinType joinType) {
            this.joinType = joinType;
        }

        @Override
        public String joinName() {
            return "NATURAL " + this.joinType.joinName();
        }
    }

    public static class UsingJoinType
    implements JoinType {
        private final List<Attribute> columns;
        private final JoinType coreJoin;

        public UsingJoinType(JoinType coreJoin, List<Attribute> columns) {
            this.columns = columns;
            this.coreJoin = coreJoin;
        }

        @Override
        public String joinName() {
            return this.coreJoin.joinName() + " USING " + this.columns.toString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            throw new IllegalArgumentException("USING join type should not be serialized due to being rewritten");
        }

        public JoinType coreJoin() {
            return this.coreJoin;
        }

        public List<Attribute> columns() {
            return this.columns;
        }

        @Override
        public boolean resolved() {
            return Resolvables.resolved(this.columns);
        }

        public int hashCode() {
            return Objects.hash(this.columns, this.coreJoin);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsingJoinType that = (UsingJoinType)o;
            return Objects.equals(this.columns, that.columns) && this.coreJoin == that.coreJoin;
        }

        public String toString() {
            return this.joinName();
        }
    }
}

