/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.stats;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.core.type.DataType;

public interface SearchStats {
    public static final SearchStats EMPTY = new EmptySearchStats();

    public boolean exists(String var1);

    public boolean isIndexed(String var1);

    public boolean hasDocValues(String var1);

    public boolean hasExactSubfield(String var1);

    public long count();

    public long count(String var1);

    public long count(String var1, BytesRef var2);

    public byte[] min(String var1, DataType var2);

    public byte[] max(String var1, DataType var2);

    public boolean isSingleValue(String var1);

    public record EmptySearchStats() implements SearchStats
    {
        @Override
        public boolean exists(String field) {
            return false;
        }

        @Override
        public boolean isIndexed(String field) {
            return false;
        }

        @Override
        public boolean hasDocValues(String field) {
            return false;
        }

        @Override
        public boolean hasExactSubfield(String field) {
            return false;
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public long count(String field) {
            return 0L;
        }

        @Override
        public long count(String field, BytesRef value) {
            return 0L;
        }

        @Override
        public byte[] min(String field, DataType dataType) {
            return null;
        }

        @Override
        public byte[] max(String field, DataType dataType) {
            return null;
        }

        @Override
        public boolean isSingleValue(String field) {
            return true;
        }
    }
}

