/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.security.authc.jwt.JwtFieldValidator;

public class JwtAlgorithmValidator
implements JwtFieldValidator {
    private final List<String> allowedAlgorithms;

    public JwtAlgorithmValidator(List<String> allowedAlgorithms) {
        this.allowedAlgorithms = allowedAlgorithms;
    }

    @Override
    public void validate(JWSHeader jwsHeader, JWTClaimsSet jwtClaimsSet) {
        JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
        if (algorithm == null) {
            throw new IllegalArgumentException("missing JWT algorithm header");
        }
        if (!this.allowedAlgorithms.contains(algorithm.getName())) {
            throw new IllegalArgumentException(Strings.format((String)"invalid JWT algorithm [%s], allowed algorithms are [%s]", (Object[])new Object[]{algorithm, org.elasticsearch.common.Strings.collectionToCommaDelimitedString(this.allowedAlgorithms)}));
        }
    }
}

