/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.proto.core.Nullable;

public class SqlQueryResponse {
    private final String cursor;
    private final List<ColumnInfo> columns;
    private final List<List<Object>> rows;
    @Nullable
    private final String asyncExecutionId;
    private final boolean isPartial;
    private final boolean isRunning;

    public SqlQueryResponse(String cursor, @Nullable List<ColumnInfo> columns, List<List<Object>> rows) {
        this(cursor, columns, rows, null, false, false);
    }

    public SqlQueryResponse(String cursor, @Nullable List<ColumnInfo> columns, List<List<Object>> rows, String asyncExecutionId, boolean isPartial, boolean isRunning) {
        this.cursor = cursor;
        this.columns = columns;
        this.rows = rows;
        this.asyncExecutionId = asyncExecutionId;
        this.isPartial = isPartial;
        this.isRunning = isRunning;
    }

    public String cursor() {
        return this.cursor;
    }

    public long size() {
        return this.rows.size();
    }

    public List<ColumnInfo> columns() {
        return this.columns;
    }

    public List<List<Object>> rows() {
        return this.rows;
    }

    public String id() {
        return this.asyncExecutionId;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlQueryResponse that = (SqlQueryResponse)o;
        return Objects.equals(this.cursor, that.cursor) && Objects.equals(this.columns, that.columns) && Objects.equals(this.rows, that.rows) && Objects.equals(this.asyncExecutionId, that.asyncExecutionId) && this.isPartial == that.isPartial && this.isRunning == that.isRunning;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.columns, this.rows, this.asyncExecutionId, this.isPartial, this.isRunning);
    }
}

