/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.collect.Lists;
import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2Cap;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import com.google.common.geometry.S2Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public strictfp class S2CellUnion
implements S2Region,
Iterable<S2CellId> {
    private ArrayList<S2CellId> cellIds = new ArrayList();

    public void initFromCellIds(ArrayList<S2CellId> cellIds) {
        this.initRawCellIds(cellIds);
        this.normalize();
    }

    public void initFromIds(ArrayList<Long> cellIds) {
        this.initRawIds(cellIds);
        this.normalize();
    }

    public void initSwap(ArrayList<S2CellId> cellIds) {
        this.initRawSwap(cellIds);
        this.normalize();
    }

    public void initRawCellIds(ArrayList<S2CellId> cellIds) {
        this.cellIds = cellIds;
    }

    public void initRawIds(ArrayList<Long> cellIds) {
        int size = cellIds.size();
        this.cellIds = new ArrayList(size);
        for (Long id : cellIds) {
            this.cellIds.add(new S2CellId(id));
        }
    }

    public void initRawSwap(ArrayList<S2CellId> cellIds) {
        this.cellIds = new ArrayList<S2CellId>(cellIds);
        cellIds.clear();
    }

    public int size() {
        return this.cellIds.size();
    }

    public S2CellId cellId(int i) {
        return this.cellIds.get(i);
    }

    @Override
    public Iterator<S2CellId> iterator() {
        return this.cellIds.iterator();
    }

    public ArrayList<S2CellId> cellIds() {
        return this.cellIds;
    }

    public void denormalize(int minLevel, int levelMod, ArrayList<S2CellId> output) {
        output.clear();
        output.ensureCapacity(this.size());
        for (S2CellId id : this) {
            int level = id.level();
            int newLevel = Math.max(minLevel, level);
            if (levelMod > 1) {
                newLevel += (30 - (newLevel - minLevel)) % levelMod;
                newLevel = Math.min(30, newLevel);
            }
            if (newLevel == level) {
                output.add(id);
                continue;
            }
            S2CellId end = id.childEnd(newLevel);
            id = id.childBegin(newLevel);
            while (!id.equals(end)) {
                output.add(id);
                id = id.next();
            }
        }
    }

    public void pack() {
        this.cellIds.trimToSize();
    }

    public boolean contains(S2CellId id) {
        int pos = Collections.binarySearch(this.cellIds, id);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (pos < this.cellIds.size() && this.cellIds.get(pos).rangeMin().lessOrEquals(id)) {
            return true;
        }
        return pos != 0 && this.cellIds.get(pos - 1).rangeMax().greaterOrEquals(id);
    }

    public boolean intersects(S2CellId id) {
        int pos = Collections.binarySearch(this.cellIds, id);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (pos < this.cellIds.size() && this.cellIds.get(pos).rangeMin().lessOrEquals(id.rangeMax())) {
            return true;
        }
        return pos != 0 && this.cellIds.get(pos - 1).rangeMax().greaterOrEquals(id.rangeMin());
    }

    public boolean contains(S2CellUnion that) {
        for (S2CellId id : that) {
            if (this.contains(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(S2Cell cell) {
        return this.contains(cell.id());
    }

    public boolean intersects(S2CellUnion union) {
        for (S2CellId id : union) {
            if (!this.intersects(id)) continue;
            return true;
        }
        return false;
    }

    public void getUnion(S2CellUnion x, S2CellUnion y) {
        this.cellIds.clear();
        this.cellIds.ensureCapacity(x.size() + y.size());
        this.cellIds.addAll(x.cellIds);
        this.cellIds.addAll(y.cellIds);
        this.normalize();
    }

    public void getIntersection(S2CellUnion x, S2CellId id) {
        this.cellIds.clear();
        if (x.contains(id)) {
            this.cellIds.add(id);
        } else {
            int pos = Collections.binarySearch(x.cellIds, id.rangeMin());
            if (pos < 0) {
                pos = -pos - 1;
            }
            S2CellId idmax = id.rangeMax();
            int size = x.cellIds.size();
            while (pos < size && x.cellIds.get(pos).lessOrEquals(idmax)) {
                this.cellIds.add(x.cellIds.get(pos++));
            }
        }
    }

    public void getIntersection(S2CellUnion x, S2CellUnion y) {
        this.cellIds.clear();
        int i = 0;
        int j = 0;
        while (i < x.cellIds.size() && j < y.cellIds.size()) {
            S2CellId jmin;
            S2CellId imin = x.cellId(i).rangeMin();
            if (imin.greaterThan(jmin = y.cellId(j).rangeMin())) {
                if (x.cellId(i).lessOrEquals(y.cellId(j).rangeMax())) {
                    this.cellIds.add(x.cellId(i++));
                    continue;
                }
                j = this.indexedBinarySearch(y.cellIds, imin, j + 1);
                if (!x.cellId(i).lessOrEquals(y.cellId(j - 1).rangeMax())) continue;
                --j;
                continue;
            }
            if (jmin.greaterThan(imin)) {
                if (y.cellId(j).lessOrEquals(x.cellId(i).rangeMax())) {
                    this.cellIds.add(y.cellId(j++));
                    continue;
                }
                i = this.indexedBinarySearch(x.cellIds, jmin, i + 1);
                if (!y.cellId(j).lessOrEquals(x.cellId(i - 1).rangeMax())) continue;
                --i;
                continue;
            }
            if (x.cellId(i).lessThan(y.cellId(j))) {
                this.cellIds.add(x.cellId(i++));
                continue;
            }
            this.cellIds.add(y.cellId(j++));
        }
    }

    private int indexedBinarySearch(List<S2CellId> l, S2CellId key, int low) {
        int high = l.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            S2CellId midVal = l.get(mid);
            int cmp = midVal.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    public void expand(int level) {
        ArrayList<S2CellId> output = new ArrayList<S2CellId>();
        long levelLsb = S2CellId.lowestOnBitForLevel(level);
        int i = this.size() - 1;
        do {
            S2CellId id;
            if ((id = this.cellId(i)).lowestOnBit() < levelLsb) {
                id = id.parent(level);
                while (i > 0 && id.contains(this.cellId(i - 1))) {
                    --i;
                }
            }
            output.add(id);
            id.getAllNeighbors(level, output);
        } while (--i >= 0);
        this.initSwap(output);
    }

    public void expand(S1Angle minRadius, int maxLevelDiff) {
        int minLevel = 30;
        for (S2CellId id : this) {
            minLevel = Math.min(minLevel, id.level());
        }
        int radiusLevel = S2Projections.MIN_WIDTH.getMaxLevel(minRadius.radians());
        if (radiusLevel == 0 && minRadius.radians() > S2Projections.MIN_WIDTH.getValue(0)) {
            this.expand(0);
        }
        this.expand(Math.min(minLevel + maxLevelDiff, radiusLevel));
    }

    public S2Region clone() {
        S2CellUnion copy = new S2CellUnion();
        copy.initRawCellIds(Lists.newArrayList(this.cellIds));
        return copy;
    }

    @Override
    public S2Cap getCapBound() {
        if (this.cellIds.isEmpty()) {
            return S2Cap.empty();
        }
        S2Point centroid = new S2Point(0.0, 0.0, 0.0);
        for (S2CellId id : this) {
            double area = S2Cell.averageArea(id.level());
            centroid = S2Point.add(centroid, S2Point.mul(id.toPoint(), area));
        }
        centroid = centroid.equals(new S2Point(0.0, 0.0, 0.0)) ? new S2Point(1.0, 0.0, 0.0) : S2Point.normalize(centroid);
        S2Cap cap = S2Cap.fromAxisHeight(centroid, 0.0);
        for (S2CellId id : this) {
            cap = cap.addCap(new S2Cell(id).getCapBound());
        }
        return cap;
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLngRect bound = S2LatLngRect.empty();
        for (S2CellId id : this) {
            bound = bound.union(new S2Cell(id).getRectBound());
        }
        return bound;
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return this.intersects(cell.id());
    }

    public boolean contains(S2Point p) {
        return this.contains(S2CellId.fromPoint(p));
    }

    public long leafCellsCovered() {
        long numLeaves = 0L;
        for (S2CellId cellId : this.cellIds) {
            int invertedLevel = 30 - cellId.level();
            numLeaves += 1L << (invertedLevel << 1);
        }
        return numLeaves;
    }

    public double averageBasedArea() {
        return S2Cell.averageArea(30) * (double)this.leafCellsCovered();
    }

    public double approxArea() {
        double area = 0.0;
        for (S2CellId cellId : this.cellIds) {
            area += new S2Cell(cellId).approxArea();
        }
        return area;
    }

    public double exactArea() {
        double area = 0.0;
        for (S2CellId cellId : this.cellIds) {
            area += new S2Cell(cellId).exactArea();
        }
        return area;
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2CellUnion)) {
            return false;
        }
        S2CellUnion union = (S2CellUnion)that;
        return this.cellIds.equals(union.cellIds);
    }

    public int hashCode() {
        int value = 17;
        for (S2CellId id : this) {
            value = 37 * value + id.hashCode();
        }
        return value;
    }

    public boolean normalize() {
        ArrayList<S2CellId> output = new ArrayList<S2CellId>(this.cellIds.size());
        output.ensureCapacity(this.cellIds.size());
        Collections.sort(this.cellIds);
        for (S2CellId id : this) {
            int size = output.size();
            if (!output.isEmpty() && output.get(size - 1).contains(id)) continue;
            while (!output.isEmpty() && id.contains(output.get(output.size() - 1))) {
                output.remove(output.size() - 1);
            }
            while (output.size() >= 3 && (output.get((size = output.size()) - 3).id() ^ output.get(size - 2).id() ^ output.get(size - 1).id()) == id.id()) {
                long mask = id.lowestOnBit() << 1;
                mask = mask + (mask << 1) ^ 0xFFFFFFFFFFFFFFFFL;
                long idMasked = id.id() & mask;
                if ((output.get(size - 3).id() & mask) != idMasked || (output.get(size - 2).id() & mask) != idMasked || (output.get(size - 1).id() & mask) != idMasked || id.isFace()) break;
                output.remove(size - 1);
                output.remove(size - 2);
                output.remove(size - 3);
                id = id.parent();
            }
            output.add(id);
        }
        if (output.size() < this.size()) {
            this.initRawSwap(output);
            return true;
        }
        return false;
    }
}

