/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.store.BlobContainerSupplier;

public class RepositorySupplier
implements Supplier<BlobStoreRepository> {
    private static final Logger logger = LogManager.getLogger(BlobContainerSupplier.class);
    private final RepositoriesService repositoriesService;
    private final String repositoryName;
    @Nullable
    private final String repositoryUuid;
    private volatile String repositoryNameHint;

    public RepositorySupplier(RepositoriesService repositoriesService, String repositoryName, String repositoryUuid) {
        this.repositoriesService = Objects.requireNonNull(repositoriesService);
        this.repositoryName = Objects.requireNonNull(repositoryName);
        this.repositoryUuid = repositoryUuid;
        this.repositoryNameHint = repositoryName;
    }

    @Override
    public BlobStoreRepository get() {
        return SearchableSnapshots.getSearchableRepository(this.getRepository());
    }

    private Repository getRepository() {
        String foundRepositoryUuid;
        String currentRepositoryNameHint;
        if (this.repositoryUuid == null) {
            Repository repository = this.repositoriesService.repository(this.repositoryName);
            assert (repository.getMetadata().name().equals(this.repositoryName)) : repository.getMetadata().name() + " vs " + this.repositoryName;
            return repository;
        }
        Map repositoriesByName = this.repositoriesService.getRepositories();
        Repository repositoryByLastKnownName = (Repository)repositoriesByName.get(currentRepositoryNameHint = this.repositoryNameHint);
        if (repositoryByLastKnownName != null && Objects.equals(this.repositoryUuid, foundRepositoryUuid = repositoryByLastKnownName.getMetadata().uuid())) {
            return repositoryByLastKnownName;
        }
        for (Repository repository : repositoriesByName.values()) {
            if (!repository.getMetadata().uuid().equals(this.repositoryUuid)) continue;
            String newRepositoryName = repository.getMetadata().name();
            logger.debug("getRepository: repository [{}] with uuid [{}] replacing repository [{}]", (Object)newRepositoryName, (Object)this.repositoryUuid, (Object)currentRepositoryNameHint);
            this.repositoryNameHint = repository.getMetadata().name();
            return repository;
        }
        throw new RepositoryMissingException("uuid [" + this.repositoryUuid + "], original name [" + this.repositoryName + "]");
    }
}

