/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.Objects;
import org.elasticsearch.common.Strings;

public final class FrameGroupID {
    private static final char UNIX_PATH_SEPARATOR = '/';

    private FrameGroupID() {
    }

    public static String getBasenameAndParent(String fullPath) {
        if (Strings.isEmpty((CharSequence)fullPath)) {
            return fullPath;
        }
        int lastSeparatorIdx = fullPath.lastIndexOf(47);
        if (lastSeparatorIdx <= 0) {
            return fullPath;
        }
        int nextSeparatorIdx = fullPath.lastIndexOf(47, lastSeparatorIdx - 1);
        return nextSeparatorIdx == -1 ? fullPath : fullPath.substring(nextSeparatorIdx + 1);
    }

    public static String create(String fileId, Integer addressOrLine, String exeFilename, String sourceFilename, String functionName) {
        if (Strings.isEmpty((CharSequence)functionName)) {
            return Integer.toString(Objects.hash(fileId, addressOrLine));
        }
        if (Strings.isEmpty((CharSequence)sourceFilename)) {
            return Integer.toString(Objects.hash(fileId, functionName));
        }
        return Integer.toString(Objects.hash(exeFilename, functionName, FrameGroupID.getBasenameAndParent(sourceFilename)));
    }
}

