/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;
import org.elasticsearch.xpack.core.scheduler.Cron;

public class ConnectorCustomSchedule
implements Writeable,
ToXContentObject {
    private final ConfigurationOverrides configurationOverrides;
    private final boolean enabled;
    private final Cron interval;
    @Nullable
    private final Instant lastSynced;
    private final String name;
    private static final ParseField CONFIG_OVERRIDES_FIELD = new ParseField("configuration_overrides", new String[0]);
    private static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    private static final ParseField INTERVAL_FIELD = new ParseField("interval", new String[0]);
    private static final ParseField LAST_SYNCED_FIELD = new ParseField("last_synced", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ConstructingObjectParser<ConnectorCustomSchedule, Void> PARSER = new ConstructingObjectParser("connector_custom_schedule", true, args -> new Builder().setConfigurationOverrides((ConfigurationOverrides)args[0]).setEnabled((Boolean)args[1]).setInterval(new Cron((String)args[2])).setLastSynced((Instant)args[3]).setName((String)args[4]).build());

    private ConnectorCustomSchedule(ConfigurationOverrides configurationOverrides, boolean enabled, Cron interval, Instant lastSynced, String name) {
        this.configurationOverrides = Objects.requireNonNull(configurationOverrides, CONFIG_OVERRIDES_FIELD.getPreferredName());
        this.enabled = enabled;
        this.interval = Objects.requireNonNull(interval, INTERVAL_FIELD.getPreferredName());
        this.lastSynced = lastSynced;
        this.name = Objects.requireNonNull(name, NAME_FIELD.getPreferredName());
    }

    public ConnectorCustomSchedule(StreamInput in) throws IOException {
        this.configurationOverrides = new ConfigurationOverrides(in);
        this.enabled = in.readBoolean();
        this.interval = new Cron(in.readString());
        this.lastSynced = in.readOptionalInstant();
        this.name = in.readString();
    }

    public static ConnectorCustomSchedule fromXContent(XContentParser parser) throws IOException {
        return (ConnectorCustomSchedule)PARSER.parse(parser, null);
    }

    public static ConnectorCustomSchedule fromXContentBytes(BytesReference source, XContentType xContentType) {
        ConnectorCustomSchedule connectorCustomSchedule;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorCustomSchedule = ConnectorCustomSchedule.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector custom schedule.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorCustomSchedule;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CONFIG_OVERRIDES_FIELD.getPreferredName(), (ToXContent)this.configurationOverrides);
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        builder.field(INTERVAL_FIELD.getPreferredName(), (ToXContent)this.interval);
        if (this.lastSynced != null) {
            builder.field(LAST_SYNCED_FIELD.getPreferredName(), (Object)this.lastSynced);
        }
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeWriteable((Writeable)this.configurationOverrides);
        out.writeBoolean(this.enabled);
        out.writeString(this.interval.expression());
        out.writeOptionalInstant(this.lastSynced);
        out.writeString(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorCustomSchedule that = (ConnectorCustomSchedule)o;
        return this.enabled == that.enabled && Objects.equals(this.configurationOverrides, that.configurationOverrides) && Objects.equals(this.interval, that.interval) && Objects.equals(this.lastSynced, that.lastSynced) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.configurationOverrides, this.enabled, this.interval, this.lastSynced, this.name);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> ConfigurationOverrides.fromXContent(parser), CONFIG_OVERRIDES_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INTERVAL_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, LAST_SYNCED_FIELD.getPreferredName()), LAST_SYNCED_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
    }

    public static class ConfigurationOverrides
    implements Writeable,
    ToXContentObject {
        @Nullable
        private final Integer maxCrawlDepth;
        @Nullable
        private final Boolean sitemapDiscoveryDisabled;
        @Nullable
        private final List<String> domainAllowList;
        @Nullable
        private final List<String> sitemapUrls;
        @Nullable
        private final List<String> seedUrls;
        private static final ParseField MAX_CRAWL_DEPTH_FIELD = new ParseField("max_crawl_depth", new String[0]);
        private static final ParseField SITEMAP_DISCOVERY_DISABLED_FIELD = new ParseField("sitemap_discovery_disabled", new String[0]);
        private static final ParseField DOMAIN_ALLOWLIST_FIELD = new ParseField("domain_allowlist", new String[0]);
        private static final ParseField SITEMAP_URLS_FIELD = new ParseField("sitemap_urls", new String[0]);
        private static final ParseField SEED_URLS_FIELD = new ParseField("seed_urls", new String[0]);
        private static final ConstructingObjectParser<ConfigurationOverrides, Void> PARSER = new ConstructingObjectParser("configuration_override", true, args -> new Builder().setMaxCrawlDepth((Integer)args[0]).setSitemapDiscoveryDisabled((Boolean)args[1]).setDomainAllowList((List)args[2]).setSitemapUrls((List)args[3]).setSeedUrls((List)args[4]).build());

        private ConfigurationOverrides(Integer maxCrawlDepth, Boolean sitemapDiscoveryDisabled, List<String> domainAllowList, List<String> sitemapUrls, List<String> seedUrls) {
            this.maxCrawlDepth = maxCrawlDepth;
            this.sitemapDiscoveryDisabled = sitemapDiscoveryDisabled;
            this.domainAllowList = domainAllowList;
            this.sitemapUrls = sitemapUrls;
            this.seedUrls = seedUrls;
        }

        public ConfigurationOverrides(StreamInput in) throws IOException {
            this.maxCrawlDepth = in.readOptionalInt();
            this.sitemapDiscoveryDisabled = in.readOptionalBoolean();
            this.domainAllowList = in.readOptionalStringCollectionAsList();
            this.sitemapUrls = in.readOptionalStringCollectionAsList();
            this.seedUrls = in.readOptionalStringCollectionAsList();
        }

        public static ConfigurationOverrides fromXContent(XContentParser parser) throws IOException {
            return (ConfigurationOverrides)PARSER.parse(parser, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.maxCrawlDepth != null) {
                builder.field(MAX_CRAWL_DEPTH_FIELD.getPreferredName(), this.maxCrawlDepth);
            }
            if (this.sitemapDiscoveryDisabled != null) {
                builder.field(SITEMAP_DISCOVERY_DISABLED_FIELD.getPreferredName(), this.sitemapDiscoveryDisabled);
            }
            if (this.domainAllowList != null) {
                builder.stringListField(DOMAIN_ALLOWLIST_FIELD.getPreferredName(), this.domainAllowList);
            }
            if (this.sitemapUrls != null) {
                builder.stringListField(SITEMAP_URLS_FIELD.getPreferredName(), this.sitemapUrls);
            }
            if (this.seedUrls != null) {
                builder.stringListField(SEED_URLS_FIELD.getPreferredName(), this.seedUrls);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalInt(this.maxCrawlDepth);
            out.writeOptionalBoolean(this.sitemapDiscoveryDisabled);
            out.writeOptionalStringCollection(this.domainAllowList);
            out.writeOptionalStringCollection(this.sitemapUrls);
            out.writeOptionalStringCollection(this.seedUrls);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationOverrides that = (ConfigurationOverrides)o;
            return Objects.equals(this.maxCrawlDepth, that.maxCrawlDepth) && Objects.equals(this.sitemapDiscoveryDisabled, that.sitemapDiscoveryDisabled) && Objects.equals(this.domainAllowList, that.domainAllowList) && Objects.equals(this.sitemapUrls, that.sitemapUrls) && Objects.equals(this.seedUrls, that.seedUrls);
        }

        public int hashCode() {
            return Objects.hash(this.maxCrawlDepth, this.sitemapDiscoveryDisabled, this.domainAllowList, this.sitemapUrls, this.seedUrls);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_CRAWL_DEPTH_FIELD);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SITEMAP_DISCOVERY_DISABLED_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), DOMAIN_ALLOWLIST_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), SITEMAP_URLS_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), SEED_URLS_FIELD);
        }

        public static class Builder {
            private Integer maxCrawlDepth;
            private Boolean sitemapDiscoveryDisabled;
            private List<String> domainAllowList;
            private List<String> sitemapUrls;
            private List<String> seedUrls;

            public Builder setMaxCrawlDepth(Integer maxCrawlDepth) {
                this.maxCrawlDepth = maxCrawlDepth;
                return this;
            }

            public Builder setSitemapDiscoveryDisabled(Boolean sitemapDiscoveryDisabled) {
                this.sitemapDiscoveryDisabled = sitemapDiscoveryDisabled;
                return this;
            }

            public Builder setDomainAllowList(List<String> domainAllowList) {
                this.domainAllowList = domainAllowList;
                return this;
            }

            public Builder setSitemapUrls(List<String> sitemapUrls) {
                this.sitemapUrls = sitemapUrls;
                return this;
            }

            public Builder setSeedUrls(List<String> seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            public ConfigurationOverrides build() {
                return new ConfigurationOverrides(this.maxCrawlDepth, this.sitemapDiscoveryDisabled, this.domainAllowList, this.sitemapUrls, this.seedUrls);
            }
        }
    }

    public static class Builder {
        private ConfigurationOverrides configurationOverrides;
        private boolean enabled;
        private Cron interval;
        private Instant lastSynced;
        private String name;

        public Builder setConfigurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setInterval(Cron interval) {
            this.interval = interval;
            return this;
        }

        public Builder setLastSynced(Instant lastSynced) {
            this.lastSynced = lastSynced;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public ConnectorCustomSchedule build() {
            return new ConnectorCustomSchedule(this.configurationOverrides, this.enabled, this.interval, this.lastSynced, this.name);
        }
    }
}

