/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.filtering.FilteringValidationInfo;

public class UpdateConnectorFilteringValidationAction {
    public static final String NAME = "cluster:admin/xpack/connector/update_filtering/draft_validation";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/update_filtering/draft_validation");

    private UpdateConnectorFilteringValidationAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final FilteringValidationInfo validation;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_filtering_validation", false, (args, connectorId) -> new Request((String)connectorId, (FilteringValidationInfo)args[0]));

        public Request(String connectorId, FilteringValidationInfo validation) {
            this.connectorId = connectorId;
            this.validation = validation;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.validation = new FilteringValidationInfo(in);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public FilteringValidationInfo getValidation() {
            return this.validation;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (this.validation == null) {
                validationException = ValidateActions.addValidationError((String)"[validation] cannot be [null].", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FilteringRules.VALIDATION_FIELD.getPreferredName(), (ToXContent)this.validation);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            this.validation.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.validation, request.validation);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.validation);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> FilteringValidationInfo.fromXContent(p), FilteringRules.VALIDATION_FIELD);
        }
    }
}

