/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.nio.charset.StandardCharsets;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MurmurHash3;

public class RollupIDGenerator {
    private boolean generated = false;
    private static final long SEED = 19L;
    private static final BytesRef DELIM = new BytesRef((CharSequence)"$");
    private static final BytesRef NULL_PLACEHOLDER = new BytesRef((CharSequence)"__NULL_PLACEHOLDER__830f1de2__");
    private final BytesRefBuilder id = new BytesRefBuilder();
    private final String jobId;

    RollupIDGenerator(String jobId) {
        this.jobId = jobId;
    }

    public void add(Integer v) {
        if (this.check(v)) {
            this.update(Numbers.intToBytes((int)v));
        }
    }

    public void add(Long v) {
        if (this.check(v)) {
            this.update(Numbers.longToBytes((long)v));
        }
    }

    public void add(Double v) {
        if (this.check(v)) {
            this.update(Numbers.doubleToBytes((double)v));
        }
    }

    public void add(String v) {
        if (this.check(v)) {
            this.update(v.getBytes(StandardCharsets.UTF_8));
        }
    }

    void addNull() {
        this.update(RollupIDGenerator.NULL_PLACEHOLDER.bytes);
    }

    private void update(byte[] v) {
        this.id.append(v, 0, v.length);
        this.id.append(DELIM);
    }

    private boolean check(Object v) {
        if (this.generated) {
            throw new RuntimeException("Cannot update ID as it has already been generated.");
        }
        if (v == null) {
            this.addNull();
            return false;
        }
        return true;
    }

    private void setFlag() {
        if (this.generated) {
            throw new RuntimeException("Cannot generate ID as it has already been generated.");
        }
        this.generated = true;
    }

    public String getID() {
        this.setFlag();
        MurmurHash3.Hash128 hasher = MurmurHash3.hash128((byte[])this.id.bytes(), (int)0, (int)this.id.length(), (long)19L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        byte[] hashedBytes = new byte[16];
        System.arraycopy(Numbers.longToBytes((long)hasher.h1), 0, hashedBytes, 0, 8);
        System.arraycopy(Numbers.longToBytes((long)hasher.h2), 0, hashedBytes, 8, 8);
        return this.jobId + "$" + Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(hashedBytes);
    }
}

