/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.physical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.eql.execution.payload.EventPayload;
import org.elasticsearch.xpack.eql.execution.search.BasicQueryClient;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.eql.plan.physical.LeafExec;
import org.elasticsearch.xpack.eql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class EsQueryExec
extends LeafExec {
    private final List<Attribute> output;
    private final QueryContainer queryContainer;

    public EsQueryExec(Source source, List<Attribute> output, QueryContainer queryContainer) {
        super(source);
        this.output = output;
        this.queryContainer = queryContainer;
    }

    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create((Node)this, EsQueryExec::new, this.output, (Object)this.queryContainer);
    }

    public EsQueryExec with(QueryContainer queryContainer) {
        return new EsQueryExec(this.source(), this.output, queryContainer);
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    public SearchSourceBuilder source(EqlSession session, boolean includeFetchFields) {
        EqlConfiguration cfg = session.configuration();
        return SourceGenerator.sourceBuilder(this.queryContainer, cfg.filter(), includeFetchFields ? cfg.fetchFields() : null, cfg.runtimeMappings());
    }

    @Override
    public void execute(EqlSession session, ActionListener<Payload> listener) {
        QueryRequest request = () -> this.source(session, true).fetchSource(FetchSourceContext.FETCH_SOURCE);
        new BasicQueryClient(session).query(request, (ActionListener<SearchResponse>)listener.safeMap(EsQueryExec.shouldReverse(request) ? r -> {
            EventPayload res = new EventPayload((SearchResponse)r);
            Collections.reverse(res.values());
            return res;
        } : EventPayload::new));
    }

    private static boolean shouldReverse(QueryRequest query) {
        SearchSourceBuilder searchSource = query.searchSource();
        for (SortBuilder sort : searchSource.sorts()) {
            if (sort.order() != SortOrder.DESC) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.queryContainer, this.output);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsQueryExec other = (EsQueryExec)obj;
        return Objects.equals(this.queryContainer, other.queryContainer) && Objects.equals(this.output, other.output);
    }

    public String nodeString() {
        return this.nodeName() + "[" + String.valueOf(this.queryContainer) + "]";
    }

    public QueryContainer queryContainer() {
        return this.queryContainer;
    }
}

