/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.stats;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.eql.stats.FeatureMetric;
import org.elasticsearch.xpack.eql.stats.QueryMetric;

public class Metrics {
    private final Map<QueryMetric, Map<OperationType, CounterMetric>> opsByTypeMetrics;
    private final Map<FeatureMetric, CounterMetric> featuresMetrics;
    protected static String QPREFIX = "queries.";

    public Metrics() {
        LinkedHashMap qMap = new LinkedHashMap();
        for (QueryMetric metric : QueryMetric.values()) {
            LinkedHashMap metricsMap = Maps.newLinkedHashMapWithExpectedSize((int)OperationType.values().length);
            for (OperationType type : OperationType.values()) {
                metricsMap.put(type, new CounterMetric());
            }
            qMap.put(metric, Collections.unmodifiableMap(metricsMap));
        }
        this.opsByTypeMetrics = Collections.unmodifiableMap(qMap);
        LinkedHashMap fMap = Maps.newLinkedHashMapWithExpectedSize((int)FeatureMetric.values().length);
        for (FeatureMetric featureMetric : FeatureMetric.values()) {
            fMap.put(featureMetric, new CounterMetric());
        }
        this.featuresMetrics = Collections.unmodifiableMap(fMap);
    }

    public void total(QueryMetric metric) {
        this.inc(metric, OperationType.TOTAL);
    }

    public void failed(QueryMetric metric) {
        this.inc(metric, OperationType.FAILED);
    }

    private void inc(QueryMetric metric, OperationType op) {
        this.opsByTypeMetrics.get((Object)metric).get((Object)op).inc();
    }

    public void inc(FeatureMetric metric) {
        this.featuresMetrics.get((Object)metric).inc();
    }

    public Counters stats() {
        Counters counters = new Counters(new String[0]);
        for (Map.Entry<QueryMetric, Map<OperationType, CounterMetric>> entry : this.opsByTypeMetrics.entrySet()) {
            String metricName = entry.getKey().toString();
            for (OperationType type : OperationType.values()) {
                long metricCounter = entry.getValue().get((Object)type).count();
                String operationTypeName = type.toString();
                counters.inc(QPREFIX + metricName + "." + operationTypeName, metricCounter);
                counters.inc(QPREFIX + "_all." + operationTypeName, metricCounter);
            }
        }
        for (Map.Entry<Enum, Map<OperationType, Object>> entry : this.featuresMetrics.entrySet()) {
            counters.inc(((FeatureMetric)entry.getKey()).prefixedName(), ((CounterMetric)entry.getValue()).count());
        }
        return counters;
    }

    private static enum OperationType {
        FAILED,
        TOTAL;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

