/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.aggregatemetric.fielddata.IndexAggregateMetricDoubleFieldData;
import org.elasticsearch.xpack.aggregatemetric.fielddata.LeafAggregateMetricDoubleFieldData;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;

public class AggregateMetricsValuesSource {

    public static abstract class AggregateMetricDouble
    extends ValuesSource {
        public abstract SortedNumericDoubleValues getAggregateMetricValues(LeafReaderContext var1, AggregateMetricDoubleFieldMapper.Metric var2) throws IOException;

        public static class Fielddata
        extends AggregateMetricDouble {
            protected final IndexAggregateMetricDoubleFieldData indexFieldData;

            public Fielddata(IndexAggregateMetricDoubleFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafAggregateMetricDoubleFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
                final SortedNumericDoubleValues values = this.getAggregateMetricValues(context, null);
                return new DocValueBits(this){

                    public boolean advanceExact(int doc) throws IOException {
                        return values.advanceExact(doc);
                    }
                };
            }

            protected Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
                throw AggregationErrors.unsupportedRounding((String)"aggregate_metric_double");
            }

            @Override
            public SortedNumericDoubleValues getAggregateMetricValues(LeafReaderContext context, AggregateMetricDoubleFieldMapper.Metric metric) throws IOException {
                return ((LeafAggregateMetricDoubleFieldData)this.indexFieldData.load(context)).getAggregateMetricValues(metric);
            }
        }
    }
}

