/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public record TransportVersion(int id) implements VersionId<TransportVersion>
{
    public static TransportVersion readVersion(StreamInput in) throws IOException {
        return TransportVersion.fromId(in.readVInt());
    }

    public static TransportVersion fromId(int id) {
        TransportVersion known = VersionsHolder.ALL_VERSIONS_MAP.get(id);
        if (known != null) {
            return known;
        }
        return new TransportVersion(id);
    }

    public static void writeVersion(TransportVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransportVersion min(TransportVersion version1, TransportVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransportVersion max(TransportVersion version1, TransportVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static boolean isCompatible(TransportVersion version) {
        return version.onOrAfter(TransportVersions.MINIMUM_COMPATIBLE);
    }

    public static TransportVersion current() {
        return VersionsHolder.CURRENT;
    }

    public static List<TransportVersion> getAllVersions() {
        return VersionsHolder.ALL_VERSIONS;
    }

    public boolean isKnown() {
        return VersionsHolder.ALL_VERSIONS_MAP.containsKey(this.id);
    }

    public TransportVersion bestKnownVersion() {
        if (this.isKnown()) {
            return this;
        }
        TransportVersion bestSoFar = TransportVersions.ZERO;
        for (TransportVersion knownVersion : VersionsHolder.ALL_VERSIONS_MAP.values()) {
            if (!knownVersion.after(bestSoFar) || !knownVersion.before(this)) continue;
            bestSoFar = knownVersion;
        }
        return bestSoFar;
    }

    public static TransportVersion fromString(String str) {
        return TransportVersion.fromId(Integer.parseInt(str));
    }

    public boolean isPatchFrom(TransportVersion version) {
        return this.onOrAfter(version) && this.id < version.id + 100 - version.id % 100;
    }

    public String toReleaseVersion() {
        return TransportVersions.VERSION_LOOKUP.apply(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    private static class VersionsHolder {
        private static final List<TransportVersion> ALL_VERSIONS;
        private static final Map<Integer, TransportVersion> ALL_VERSIONS_MAP;
        private static final TransportVersion CURRENT;

        private VersionsHolder() {
        }

        static {
            Collection extendedVersions = ExtensionLoader.loadSingleton(ServiceLoader.load(VersionExtension.class)).map(VersionExtension::getTransportVersions).orElse(Collections.emptyList());
            ALL_VERSIONS = extendedVersions.isEmpty() ? TransportVersions.DEFINED_VERSIONS : Stream.concat(TransportVersions.DEFINED_VERSIONS.stream(), extendedVersions.stream()).sorted().toList();
            ALL_VERSIONS_MAP = ALL_VERSIONS.stream().collect(Collectors.toUnmodifiableMap(TransportVersion::id, Function.identity()));
            CURRENT = ALL_VERSIONS.getLast();
        }
    }
}

