/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClearVotingConfigExclusionsAction
extends TransportMasterNodeAction<ClearVotingConfigExclusionsRequest, ActionResponse.Empty> {
    public static final ActionType<ActionResponse.Empty> TYPE = new ActionType("cluster:admin/voting_config/clear_exclusions");
    private static final Logger logger = LogManager.getLogger(TransportClearVotingConfigExclusionsAction.class);
    private final Reconfigurator reconfigurator;

    @Inject
    public TransportClearVotingConfigExclusionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Reconfigurator reconfigurator) {
        super(TYPE.name(), false, transportService, clusterService, threadPool, actionFilters, ClearVotingConfigExclusionsRequest::new, in -> ActionResponse.Empty.INSTANCE, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.reconfigurator = reconfigurator;
    }

    @Override
    protected void masterOperation(Task task, final ClearVotingConfigExclusionsRequest request, final ClusterState initialState, final ActionListener<ActionResponse.Empty> listener) throws Exception {
        this.reconfigurator.ensureVotingConfigCanBeModified();
        final long startTimeMillis = this.threadPool.relativeTimeInMillis();
        Predicate<ClusterState> allExclusionsRemoved = newState -> {
            for (CoordinationMetadata.VotingConfigExclusion tombstone : initialState.getVotingConfigExclusions()) {
                if (!newState.nodes().nodeExists(tombstone.getNodeId())) continue;
                return false;
            }
            return true;
        };
        if (request.getWaitForRemoval() && !allExclusionsRemoved.test(initialState)) {
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, request.getTimeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    TransportClearVotingConfigExclusionsAction.this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new ElasticsearchException("cluster service closed while waiting for removal of nodes " + String.valueOf(initialState.getVotingConfigExclusions()), new Object[0]));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure(new ElasticsearchTimeoutException("timed out waiting for removal of nodes; if nodes should not be removed, set ?wait_for_removal=false. " + String.valueOf(initialState.getVotingConfigExclusions()), new Object[0]));
                }
            }, allExclusionsRemoved);
        } else {
            this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
        }
    }

    private void submitClearVotingConfigExclusionsTask(ClearVotingConfigExclusionsRequest request, long startTimeMillis, final ActionListener<ActionResponse.Empty> listener) {
        this.submitUnbatchedTask("clear-voting-config-exclusions", new ClusterStateUpdateTask(this, Priority.URGENT, TimeValue.timeValueMillis((long)Math.max(0L, request.getTimeout().millis() + startTimeMillis - this.threadPool.relativeTimeInMillis()))){

            @Override
            public ClusterState execute(ClusterState currentState) {
                CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).clearVotingConfigExclusions().build();
                Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(newCoordinationMetadata).build();
                return ClusterState.builder(currentState).metadata(newMetadata).build();
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse(ActionResponse.Empty.INSTANCE);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    @Override
    protected ClusterBlockException checkBlock(ClearVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

