/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ClusterHealthRequest
extends MasterNodeReadRequest<ClusterHealthRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandHidden();
    private TimeValue timeout = TimeValue.timeValueSeconds((long)30L);
    private ClusterHealthStatus waitForStatus;
    private boolean waitForNoRelocatingShards = false;
    private boolean waitForNoInitializingShards = false;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;
    private String waitForNodes = "";
    private Priority waitForEvents = null;

    public ClusterHealthRequest(TimeValue masterNodeTimeout) {
        super(masterNodeTimeout);
    }

    public ClusterHealthRequest(TimeValue masterNodeTimeout, String ... indices) {
        super(masterNodeTimeout);
        this.indices = indices;
    }

    public ClusterHealthRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.timeout = in.readTimeValue();
        if (in.readBoolean()) {
            this.waitForStatus = ClusterHealthStatus.readFrom(in);
        }
        this.waitForNoRelocatingShards = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.waitForNodes = in.readString();
        if (in.readBoolean()) {
            this.waitForEvents = Priority.readFrom(in);
        }
        this.waitForNoInitializingShards = in.readBoolean();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeStringArray(this.indices);
        }
        out.writeTimeValue(this.timeout);
        if (this.waitForStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.waitForStatus.value());
        }
        out.writeBoolean(this.waitForNoRelocatingShards);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.waitForNodes);
        if (this.waitForEvents == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Priority.writeTo(this.waitForEvents, out);
        }
        out.writeBoolean(this.waitForNoInitializingShards);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterHealthRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterHealthRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ClusterHealthRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public ClusterHealthStatus waitForStatus() {
        return this.waitForStatus;
    }

    public ClusterHealthRequest waitForStatus(ClusterHealthStatus waitForStatus) {
        this.waitForStatus = waitForStatus;
        return this;
    }

    public ClusterHealthRequest waitForGreenStatus() {
        return this.waitForStatus(ClusterHealthStatus.GREEN);
    }

    public ClusterHealthRequest waitForYellowStatus() {
        return this.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    public boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    public ClusterHealthRequest waitForNoRelocatingShards(boolean waitForNoRelocatingShards) {
        this.waitForNoRelocatingShards = waitForNoRelocatingShards;
        return this;
    }

    public boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    public ClusterHealthRequest waitForNoInitializingShards(boolean waitForNoInitializingShards) {
        this.waitForNoInitializingShards = waitForNoInitializingShards;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ClusterHealthRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards.equals(ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        return this;
    }

    public ClusterHealthRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public String waitForNodes() {
        return this.waitForNodes;
    }

    public ClusterHealthRequest waitForNodes(String waitForNodes) {
        this.waitForNodes = waitForNodes;
        return this;
    }

    public ClusterHealthRequest waitForEvents(Priority waitForEvents) {
        this.waitForEvents = waitForEvents;
        return this;
    }

    public Priority waitForEvents() {
        return this.waitForEvents;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }
}

