/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get.shard;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.get.shard.GetShardSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.shard.GetShardSnapshotResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.IndexSnapshotsService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.ShardSnapshotInfo;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetShardSnapshotAction
extends TransportMasterNodeAction<GetShardSnapshotRequest, GetShardSnapshotResponse> {
    public static final ActionType<GetShardSnapshotResponse> TYPE = new ActionType("internal:admin/snapshot/get_shard");
    private final IndexSnapshotsService indexSnapshotsService;

    @Inject
    public TransportGetShardSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, GetShardSnapshotRequest::new, GetShardSnapshotResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexSnapshotsService = new IndexSnapshotsService(repositoriesService);
    }

    @Override
    protected void masterOperation(Task task, GetShardSnapshotRequest request, ClusterState state, ActionListener<GetShardSnapshotResponse> listener) throws Exception {
        Iterator<String> repositories = TransportGetShardSnapshotAction.getRequestedRepositories(request, state);
        if (repositories.hasNext()) {
            new AsyncOperation(request, repositories, listener).processNextRepository();
        } else {
            listener.onResponse(GetShardSnapshotResponse.EMPTY);
        }
    }

    private static Iterator<String> getRequestedRepositories(GetShardSnapshotRequest request, ClusterState state) {
        if (request.getFromAllRepositories()) {
            return Iterators.map(RepositoriesMetadata.get(state).repositories().iterator(), RepositoryMetadata::name);
        }
        return request.getRepositories().iterator();
    }

    @Override
    protected ClusterBlockException checkBlock(GetShardSnapshotRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private class AsyncOperation {
        private static final Comparator<ShardSnapshotInfo> LATEST_SNAPSHOT_COMPARATOR = Comparator.comparing(ShardSnapshotInfo::getStartedAt).thenComparing(snapshotInfo -> snapshotInfo.getSnapshot().getSnapshotId());
        private final GetShardSnapshotRequest request;
        private final Iterator<String> repositories;
        private final ActionListener<GetShardSnapshotResponse> responseListener;
        @Nullable
        ShardSnapshotInfo latestShardSnapshot;
        Map<String, RepositoryException> repositoryFailures = new HashMap<String, RepositoryException>();

        AsyncOperation(GetShardSnapshotRequest request, Iterator<String> repositories, ActionListener<GetShardSnapshotResponse> listener) {
            this.request = request;
            this.repositories = repositories;
            this.responseListener = listener;
        }

        void processNextRepository() {
            assert (this.repositories.hasNext());
            TransportGetShardSnapshotAction.this.indexSnapshotsService.getLatestSuccessfulSnapshotForShard(this.repositories.next(), this.request.getShardId(), new ActionListener<Optional<ShardSnapshotInfo>>(){

                @Override
                public void onResponse(Optional<ShardSnapshotInfo> optionalShardSnapshotInfo) {
                    optionalShardSnapshotInfo.ifPresent(shardSnapshotInfo -> {
                        if (AsyncOperation.this.latestShardSnapshot == null || LATEST_SNAPSHOT_COMPARATOR.compare(AsyncOperation.this.latestShardSnapshot, (ShardSnapshotInfo)shardSnapshotInfo) < 0) {
                            AsyncOperation.this.latestShardSnapshot = shardSnapshotInfo;
                        }
                    });
                    this.next();
                }

                @Override
                public void onFailure(Exception e) {
                    if (!AsyncOperation.this.request.isSingleRepositoryRequest() && e instanceof RepositoryException) {
                        RepositoryException repositoryException = (RepositoryException)e;
                        AsyncOperation.this.repositoryFailures.put(repositoryException.repository(), repositoryException);
                        this.next();
                    } else {
                        AsyncOperation.this.responseListener.onFailure(e);
                    }
                }

                private void next() {
                    if (AsyncOperation.this.repositories.hasNext()) {
                        AsyncOperation.this.processNextRepository();
                    } else {
                        AsyncOperation.this.responseListener.onResponse(new GetShardSnapshotResponse(AsyncOperation.this.latestShardSnapshot, AsyncOperation.this.repositoryFailures));
                    }
                }
            });
        }
    }
}

