/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class FieldScriptStats
implements Writeable,
ToXContentFragment {
    private long maxLines = 0L;
    private long totalLines = 0L;
    private long maxChars = 0L;
    private long totalChars = 0L;
    private long maxSourceUsages = 0L;
    private long totalSourceUsages = 0L;
    private long maxDocUsages = 0L;
    private long totalDocUsages = 0L;

    FieldScriptStats() {
    }

    FieldScriptStats(StreamInput in) throws IOException {
        this.maxLines = in.readLong();
        this.totalLines = in.readLong();
        this.maxChars = in.readLong();
        this.totalChars = in.readLong();
        this.maxSourceUsages = in.readLong();
        this.totalSourceUsages = in.readLong();
        this.maxDocUsages = in.readLong();
        this.totalDocUsages = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.maxLines);
        out.writeLong(this.totalLines);
        out.writeLong(this.maxChars);
        out.writeLong(this.totalChars);
        out.writeLong(this.maxSourceUsages);
        out.writeLong(this.totalSourceUsages);
        out.writeLong(this.maxDocUsages);
        out.writeLong(this.totalDocUsages);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("lines_max", this.maxLines);
        builder.field("lines_total", this.totalLines);
        builder.field("chars_max", this.maxChars);
        builder.field("chars_total", this.totalChars);
        builder.field("source_max", this.maxSourceUsages);
        builder.field("source_total", this.totalSourceUsages);
        builder.field("doc_max", this.maxDocUsages);
        builder.field("doc_total", this.totalDocUsages);
        return builder;
    }

    void update(int chars, long lines, int sourceUsages, int docUsages, int count) {
        this.maxChars = Math.max(this.maxChars, (long)chars);
        this.totalChars += (long)chars * (long)count;
        this.maxLines = Math.max(this.maxLines, lines);
        this.totalLines += lines * (long)count;
        this.totalSourceUsages += (long)sourceUsages * (long)count;
        this.maxSourceUsages = Math.max(this.maxSourceUsages, (long)sourceUsages);
        this.totalDocUsages += (long)docUsages * (long)count;
        this.maxDocUsages = Math.max(this.maxDocUsages, (long)docUsages);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldScriptStats that = (FieldScriptStats)o;
        return this.maxLines == that.maxLines && this.totalLines == that.totalLines && this.maxChars == that.maxChars && this.totalChars == that.totalChars && this.maxSourceUsages == that.maxSourceUsages && this.totalSourceUsages == that.totalSourceUsages && this.maxDocUsages == that.maxDocUsages && this.totalDocUsages == that.totalDocUsages;
    }

    public int hashCode() {
        return Objects.hash(this.maxLines, this.totalLines, this.maxChars, this.totalChars, this.maxSourceUsages, this.totalSourceUsages, this.maxDocUsages, this.totalDocUsages);
    }
}

