/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.core.Predicates;

final class ResponseRewriter {
    ResponseRewriter() {
    }

    public static Map<String, IndexFieldCapabilities> rewriteOldResponses(TransportVersion version, Map<String, IndexFieldCapabilities> input, String[] filters, String[] allowedTypes) {
        if (version.onOrAfter(TransportVersions.V_8_2_0)) {
            return input;
        }
        Function<IndexFieldCapabilities, IndexFieldCapabilities> transformer = ResponseRewriter.buildTransformer(input, filters, allowedTypes);
        HashMap<String, IndexFieldCapabilities> rewritten = new HashMap<String, IndexFieldCapabilities>();
        for (Map.Entry<String, IndexFieldCapabilities> entry : input.entrySet()) {
            IndexFieldCapabilities fc = transformer.apply(entry.getValue());
            if (fc == null) continue;
            rewritten.put(entry.getKey(), fc);
        }
        return rewritten;
    }

    private static Function<IndexFieldCapabilities, IndexFieldCapabilities> buildTransformer(Map<String, IndexFieldCapabilities> input, String[] filters, String[] allowedTypes) {
        Predicate<IndexFieldCapabilities> test = Predicates.always();
        Set<String> objects = null;
        Set<String> nestedObjects = null;
        if (allowedTypes.length > 0) {
            Set<String> set = Set.of(allowedTypes);
            test = test.and(ifc -> set.contains(ifc.type()));
        }
        for (String filter : filters) {
            if ("-parent".equals(filter)) {
                test = test.and(fc -> !fc.type().equals("nested") && !fc.type().equals("object"));
            }
            if ("-metadata".equals(filter)) {
                test = test.and(fc -> !fc.isMetadatafield());
            }
            if ("+metadata".equals(filter)) {
                test = test.and(IndexFieldCapabilities::isMetadatafield);
            }
            if ("-nested".equals(filter)) {
                if (nestedObjects == null) {
                    nestedObjects = ResponseRewriter.findTypes("nested", input);
                }
                Set<String> no = nestedObjects;
                test = test.and(fc -> !ResponseRewriter.isNestedField(fc.name(), no));
            }
            if (!"-multifield".equals(filter)) continue;
            if (objects == null) {
                objects = ResponseRewriter.findTypes("object", input);
            }
            Set<String> o = objects;
            test = test.and(fc -> ResponseRewriter.isNotMultifield(fc.name(), o));
        }
        Predicate<IndexFieldCapabilities> predicate = test;
        return fc -> {
            if (!finalTest.test((IndexFieldCapabilities)fc)) {
                return null;
            }
            return fc;
        };
    }

    private static Set<String> findTypes(String type, Map<String, IndexFieldCapabilities> fieldCaps) {
        return fieldCaps.entrySet().stream().filter(entry -> type.equals(((IndexFieldCapabilities)entry.getValue()).type())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static boolean isNestedField(String field, Set<String> nestedParents) {
        for (String parent : nestedParents) {
            if (!field.startsWith(parent + ".") && !field.equals(parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotMultifield(String field, Set<String> objectFields) {
        int lastDotPos = field.lastIndexOf(46);
        if (lastDotPos == -1) {
            return true;
        }
        String parent = field.substring(0, lastDotPos);
        return objectFields.contains(parent);
    }
}

