/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Arrays;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class DestructiveOperations {
    public static final Setting<Boolean> REQUIRES_NAME_SETTING = Setting.boolSetting("action.destructive_requires_name", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final String[] MATCH_NONE_PATTERN = new String[]{"*", "-*"};
    private volatile boolean destructiveRequiresName;

    public DestructiveOperations(Settings settings, ClusterSettings clusterSettings) {
        this.destructiveRequiresName = REQUIRES_NAME_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(REQUIRES_NAME_SETTING, this::setDestructiveRequiresName);
    }

    private void setDestructiveRequiresName(boolean destructiveRequiresName) {
        this.destructiveRequiresName = destructiveRequiresName;
    }

    public void failDestructive(String[] aliasesOrIndices) {
        if (!this.destructiveRequiresName) {
            return;
        }
        if (aliasesOrIndices == null || aliasesOrIndices.length == 0) {
            throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
        }
        if (aliasesOrIndices.length == 1) {
            if (DestructiveOperations.hasWildcardUsage(aliasesOrIndices[0])) {
                throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
            }
        } else if (!Arrays.equals(aliasesOrIndices, MATCH_NONE_PATTERN)) {
            for (String aliasesOrIndex : aliasesOrIndices) {
                if (!DestructiveOperations.hasWildcardUsage(aliasesOrIndex)) continue;
                throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
            }
        }
    }

    private static boolean hasWildcardUsage(String aliasOrIndex) {
        return "_all".equals(aliasOrIndex) || aliasOrIndex.indexOf(42) != -1;
    }
}

