/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transports;

public class PlainActionFuture<T>
implements ActionFuture<T>,
ActionListener<T> {
    private static final String BLOCKING_OP_REASON = "Blocking operation";
    private final Sync<T> sync = new Sync();

    @Override
    public void onResponse(@Nullable T result) {
        this.set(result);
    }

    @Override
    public void onFailure(Exception e) {
        assert (this.assertCompleteAllowed());
        if (this.sync.setException(Objects.requireNonNull(e))) {
            this.done(false);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        assert (timeout <= 0L || this.blockingAllowed());
        return this.sync.get(unit.toNanos(timeout));
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        assert (this.blockingAllowed());
        return this.sync.get();
    }

    protected boolean blockingAllowed() {
        return Transports.assertNotTransportThread(BLOCKING_OP_REASON) && ThreadPool.assertNotScheduleThread(BLOCKING_OP_REASON) && ClusterApplierService.assertNotClusterStateUpdateThread(BLOCKING_OP_REASON) && MasterService.assertNotMasterUpdateThread(BLOCKING_OP_REASON);
    }

    @Override
    public boolean isDone() {
        return this.sync.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        assert (this.assertCompleteAllowed());
        if (!this.sync.cancel()) {
            return false;
        }
        this.done(false);
        return true;
    }

    protected final boolean set(@Nullable T value) {
        assert (this.assertCompleteAllowed());
        boolean result = this.sync.set(value);
        if (result) {
            this.done(true);
        }
        return result;
    }

    protected void done(boolean success) {
    }

    @Override
    public T actionGet() {
        try {
            return FutureUtils.get(this);
        }
        catch (ElasticsearchException e) {
            throw PlainActionFuture.unwrapEsException(e);
        }
    }

    @Override
    public T actionGet(TimeValue timeout) {
        return this.actionGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T actionGet(long timeout, TimeUnit unit) {
        try {
            return FutureUtils.get(this, timeout, unit);
        }
        catch (ElasticsearchException e) {
            throw PlainActionFuture.unwrapEsException(e);
        }
    }

    public T result() throws ExecutionException {
        return this.sync.result();
    }

    private static RuntimeException unwrapEsException(ElasticsearchException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)root;
            return runtimeException;
        }
        return new UncategorizedExecutionException("Failed execution", root);
    }

    private boolean assertCompleteAllowed() {
        Thread waiter = this.sync.getFirstQueuedThread();
        assert (waiter == null || this.allowedExecutors(waiter, Thread.currentThread())) : "cannot complete future on thread " + String.valueOf(Thread.currentThread()) + " with waiter on thread " + String.valueOf(waiter) + ", could deadlock if pool was full\n" + ExceptionsHelper.formatStackTrace(waiter.getStackTrace());
        return true;
    }

    boolean allowedExecutors(Thread blockedThread, Thread completingThread) {
        assert (blockedThread != completingThread) : "only call this for different threads";
        String blockedThreadName = EsExecutors.executorName(blockedThread);
        String completingThreadName = EsExecutors.executorName(completingThread);
        return blockedThreadName == null || completingThreadName == null || !blockedThreadName.equals(completingThreadName);
    }

    static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        static final int RUNNING = 0;
        static final int COMPLETING = 1;
        static final int COMPLETED = 2;
        static final int CANCELLED = 4;
        private V value;
        private Exception exception;

        Sync() {
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            if (this.isDone()) {
                return 1;
            }
            return -1;
        }

        @Override
        protected boolean tryReleaseShared(int finalState) {
            this.setState(finalState);
            return true;
        }

        V get(long nanos) throws TimeoutException, CancellationException, ExecutionException, InterruptedException {
            if (!this.tryAcquireSharedNanos(-1, nanos)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        V get() throws CancellationException, ExecutionException, InterruptedException {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        private V getValue() throws CancellationException, ExecutionException {
            int state = this.getState();
            switch (state) {
                case 2: {
                    if (this.exception != null) {
                        throw new ExecutionException(this.exception);
                    }
                    return this.value;
                }
                case 4: {
                    throw new CancellationException("Task was cancelled.");
                }
            }
            throw new IllegalStateException("Error, synchronizer in invalid state: " + state);
        }

        V result() throws CancellationException, ExecutionException {
            assert (this.isDone()) : "Error, synchronizer in invalid state: " + this.getState();
            return this.getValue();
        }

        boolean isDone() {
            return (this.getState() & 6) != 0;
        }

        boolean isCancelled() {
            return this.getState() == 4;
        }

        boolean set(@Nullable V v) {
            return this.complete(v, null, 2);
        }

        boolean setException(Exception e) {
            return this.complete(null, e, 2);
        }

        boolean cancel() {
            return this.complete(null, null, 4);
        }

        private boolean complete(@Nullable V v, @Nullable Exception e, int finalState) {
            boolean doCompletion = this.compareAndSetState(0, 1);
            if (doCompletion) {
                this.value = v;
                this.exception = e;
                this.releaseShared(finalState);
            } else if (this.getState() == 1) {
                while (!this.isDone()) {
                    Thread.onSpinWait();
                }
            }
            return doCompletion;
        }
    }
}

