/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;

public abstract class SingleShardRequest<Request extends SingleShardRequest<Request>>
extends ActionRequest
implements IndicesRequest.RemoteClusterShardRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    @Nullable
    protected String index;
    ShardId internalShardId;

    public SingleShardRequest() {
    }

    public SingleShardRequest(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.internalShardId = new ShardId(in);
        }
        this.index = in.readOptionalString();
    }

    protected SingleShardRequest(String index) {
        this.index = index;
    }

    protected ActionRequestValidationException validateNonNullIndex() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    public List<ShardId> shards() {
        return Collections.singletonList(this.internalShardId);
    }

    @Override
    public IndicesOptions indicesOptions() {
        return INDICES_OPTIONS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.internalShardId);
        out.writeOptionalString(this.index);
    }
}

