/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;

public class ConsoleLoader {
    private static final String CONSOLE_LOADER_CLASS = "org.elasticsearch.io.ansi.AnsiConsoleLoader";

    public static Console loadConsole(Environment env) {
        ClassLoader classLoader = ConsoleLoader.buildClassLoader(env);
        Supplier<Console> supplier = ConsoleLoader.buildConsoleLoader(classLoader);
        return supplier.get();
    }

    static Supplier<Console> buildConsoleLoader(ClassLoader classLoader) {
        try {
            Class<?> cls = classLoader.loadClass(CONSOLE_LOADER_CLASS);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            Supplier supplier = (Supplier)constructor.newInstance(new Object[0]);
            return supplier;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load ANSI console", e);
        }
    }

    private static ClassLoader buildClassLoader(Environment env) {
        URLClassLoader uRLClassLoader;
        block8: {
            Path libDir = env.libDir().resolve("tools").resolve("ansi-console");
            Stream<Path> libDirFilesStream = Files.list(libDir);
            try {
                URL[] urls = (URL[])libDirFilesStream.filter(each -> each.getFileName().toString().endsWith(".jar")).map(ConsoleLoader::pathToURL).toArray(URL[]::new);
                uRLClassLoader = URLClassLoader.newInstance(urls, ConsoleLoader.class.getClassLoader());
                if (libDirFilesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (libDirFilesStream != null) {
                        try {
                            libDirFilesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to list jars in [" + String.valueOf(libDir) + "]: " + e.getMessage(), e);
                }
            }
            libDirFilesStream.close();
        }
        return uRLClassLoader;
    }

    private static URL pathToURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to convert path [" + String.valueOf(path) + "] to URL", e);
        }
    }

    public record Console(PrintStream printStream, Supplier<Integer> width, Boolean ansiEnabled, @Nullable Charset charset) {
    }
}

