/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.BatchSummary;
import org.elasticsearch.tasks.Task;

public class ClusterStatePublicationEvent {
    private static final long NOT_SET = -1L;
    private final BatchSummary summary;
    private final ClusterState oldState;
    private final ClusterState newState;
    private final Task task;
    private final long computationTimeMillis;
    private final long publicationStartTimeMillis;
    private volatile long publicationContextConstructionElapsedMillis = -1L;
    private volatile long publicationCommitElapsedMillis = -1L;
    private volatile long publicationCompletionElapsedMillis = -1L;
    private volatile long masterApplyElapsedMillis = -1L;

    public ClusterStatePublicationEvent(BatchSummary summary, ClusterState oldState, ClusterState newState, Task task, long computationTimeMillis, long publicationStartTimeMillis) {
        this.summary = summary;
        this.oldState = oldState;
        this.newState = newState;
        this.task = task;
        this.computationTimeMillis = computationTimeMillis;
        this.publicationStartTimeMillis = publicationStartTimeMillis;
    }

    public BatchSummary getSummary() {
        return this.summary;
    }

    public ClusterState getOldState() {
        return this.oldState;
    }

    public ClusterState getNewState() {
        return this.newState;
    }

    public Task getTask() {
        return this.task;
    }

    public long getComputationTimeMillis() {
        return this.computationTimeMillis;
    }

    public long getPublicationStartTimeMillis() {
        return this.publicationStartTimeMillis;
    }

    public void setPublicationContextConstructionElapsedMillis(long millis) {
        assert (millis >= 0L);
        assert (this.publicationContextConstructionElapsedMillis == -1L);
        this.publicationContextConstructionElapsedMillis = millis;
    }

    public void setPublicationCommitElapsedMillis(long millis) {
        assert (millis >= 0L);
        assert (this.publicationCommitElapsedMillis == -1L);
        this.publicationCommitElapsedMillis = millis;
    }

    public void setPublicationCompletionElapsedMillis(long millis) {
        assert (millis >= 0L);
        assert (this.publicationCompletionElapsedMillis == -1L);
        this.publicationCompletionElapsedMillis = millis;
    }

    public void setMasterApplyElapsedMillis(long millis) {
        assert (millis >= 0L);
        assert (this.masterApplyElapsedMillis == -1L);
        this.masterApplyElapsedMillis = millis;
    }

    public long getPublicationContextConstructionElapsedMillis() {
        assert (this.publicationContextConstructionElapsedMillis != -1L);
        return this.publicationContextConstructionElapsedMillis;
    }

    public long getPublicationCommitElapsedMillis() {
        assert (this.publicationCommitElapsedMillis != -1L);
        return this.publicationCommitElapsedMillis;
    }

    public long getPublicationCompletionElapsedMillis() {
        assert (this.publicationCompletionElapsedMillis != -1L);
        return this.publicationCompletionElapsedMillis;
    }

    public long getMasterApplyElapsedMillis() {
        assert (this.masterApplyElapsedMillis != -1L);
        return this.masterApplyElapsedMillis;
    }

    public long maybeGetPublicationContextConstructionElapsedMillis() {
        return ClusterStatePublicationEvent.ifSet(this.publicationContextConstructionElapsedMillis);
    }

    public long maybeGetPublicationCommitElapsedMillis() {
        return ClusterStatePublicationEvent.ifSet(this.publicationCommitElapsedMillis);
    }

    public long maybeGetPublicationCompletionElapsedMillis() {
        return ClusterStatePublicationEvent.ifSet(this.publicationCompletionElapsedMillis);
    }

    public long maybeGetMasterApplyElapsedMillis() {
        return ClusterStatePublicationEvent.ifSet(this.masterApplyElapsedMillis);
    }

    private static long ifSet(long millis) {
        assert (millis == -1L || millis >= 0L);
        return millis == -1L ? 0L : millis;
    }
}

