/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;

public interface IndexAbstraction {
    public Type getType();

    public String getName();

    public List<Index> getIndices();

    default public List<Index> getFailureIndices(@Nullable Metadata metadata) {
        return List.of();
    }

    @Nullable
    public Index getWriteIndex();

    @Nullable
    default public Index getWriteFailureIndex(Metadata metadata) {
        return null;
    }

    default public Index getWriteIndex(IndexRequest request, Metadata metadata) {
        return this.getWriteIndex();
    }

    @Nullable
    public DataStream getParentDataStream();

    public boolean isHidden();

    public boolean isSystem();

    default public boolean isDataStreamRelated() {
        return false;
    }

    public static class Alias
    implements IndexAbstraction {
        private final String aliasName;
        private final List<Index> referenceIndices;
        private final Index writeIndex;
        private final boolean isHidden;
        private final boolean isSystem;
        private final boolean dataStreamAlias;
        private final List<String> dataStreams;

        public Alias(AliasMetadata aliasMetadata, List<IndexMetadata> indexMetadatas) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndices = new ArrayList<Index>(indexMetadatas.size());
            boolean isSystem = true;
            Index widx = null;
            for (IndexMetadata imd : indexMetadatas) {
                this.referenceIndices.add(imd.getIndex());
                if (Boolean.TRUE.equals(imd.getAliases().get(this.aliasName).writeIndex())) {
                    if (widx != null) {
                        throw new IllegalStateException("write indices size can only be 0 or 1, but is at least 2");
                    }
                    widx = imd.getIndex();
                }
                isSystem = isSystem && imd.isSystem();
            }
            this.referenceIndices.sort(Index.COMPARE_BY_NAME);
            if (widx == null && indexMetadatas.size() == 1 && indexMetadatas.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                widx = indexMetadatas.get(0).getIndex();
            }
            this.writeIndex = widx;
            this.isHidden = aliasMetadata.isHidden() == null ? false : aliasMetadata.isHidden();
            this.isSystem = isSystem;
            this.dataStreamAlias = false;
            this.dataStreams = List.of();
        }

        public Alias(DataStreamAlias dataStreamAlias, List<Index> indicesOfAllDataStreams, Index writeIndexOfWriteDataStream, List<String> dataStreams) {
            this.aliasName = dataStreamAlias.getName();
            this.referenceIndices = indicesOfAllDataStreams;
            this.writeIndex = writeIndexOfWriteDataStream;
            this.isHidden = false;
            this.isSystem = false;
            this.dataStreamAlias = true;
            this.dataStreams = dataStreams;
        }

        @Override
        public Type getType() {
            return Type.ALIAS;
        }

        @Override
        public String getName() {
            return this.aliasName;
        }

        @Override
        public List<Index> getIndices() {
            return this.referenceIndices;
        }

        @Override
        public List<Index> getFailureIndices(Metadata metadata) {
            if (!this.isDataStreamRelated()) {
                return List.of();
            }
            assert (metadata != null) : "metadata must not be null to be able to retrieve the failure indices";
            ArrayList<Index> failureIndices = new ArrayList<Index>();
            for (String dataStreamName : this.dataStreams) {
                DataStream dataStream = metadata.dataStreams().get(dataStreamName);
                if (dataStream == null || dataStream.getFailureIndices().isEmpty()) continue;
                failureIndices.addAll(dataStream.getFailureIndices());
            }
            return failureIndices;
        }

        @Override
        @Nullable
        public Index getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        @Nullable
        public Index getWriteFailureIndex(Metadata metadata) {
            if (!this.isDataStreamRelated() || this.writeIndex == null) {
                return null;
            }
            assert (metadata != null) : "metadata must not be null to be able to retrieve the failure indices";
            DataStream dataStream = ((IndexAbstraction)metadata.getIndicesLookup().get(this.writeIndex.getName())).getParentDataStream();
            return dataStream == null ? null : dataStream.getWriteFailureIndex();
        }

        @Override
        public Index getWriteIndex(IndexRequest request, Metadata metadata) {
            if (!this.dataStreamAlias) {
                return this.getWriteIndex();
            }
            return ((IndexAbstraction)metadata.getIndicesLookup().get(this.getWriteIndex().getName())).getParentDataStream().getWriteIndex(request, metadata);
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        @Override
        public boolean isDataStreamRelated() {
            return this.dataStreamAlias;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alias alias = (Alias)o;
            return this.isHidden == alias.isHidden && this.isSystem == alias.isSystem && this.dataStreamAlias == alias.dataStreamAlias && this.aliasName.equals(alias.aliasName) && this.referenceIndices.equals(alias.referenceIndices) && Objects.equals(this.writeIndex, alias.writeIndex);
        }

        public int hashCode() {
            return Objects.hash(this.aliasName, this.referenceIndices, this.writeIndex, this.isHidden, this.isSystem, this.dataStreamAlias);
        }
    }

    public static class ConcreteIndex
    implements IndexAbstraction {
        private final Index concreteIndex;
        private final boolean isHidden;
        private final boolean isSystem;
        private final DataStream dataStream;

        public ConcreteIndex(IndexMetadata indexMetadata, DataStream dataStream) {
            this.concreteIndex = indexMetadata.getIndex();
            this.isHidden = indexMetadata.isHidden();
            this.isSystem = indexMetadata.isSystem();
            this.dataStream = dataStream;
        }

        public ConcreteIndex(IndexMetadata indexMetadata) {
            this(indexMetadata, null);
        }

        @Override
        public String getName() {
            return this.concreteIndex.getName();
        }

        @Override
        public Type getType() {
            return Type.CONCRETE_INDEX;
        }

        @Override
        public List<Index> getIndices() {
            return List.of(this.concreteIndex);
        }

        @Override
        public Index getWriteIndex() {
            return this.concreteIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return this.dataStream;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcreteIndex that = (ConcreteIndex)o;
            return this.isHidden == that.isHidden && this.isSystem == that.isSystem && this.concreteIndex.equals(that.concreteIndex) && Objects.equals(this.dataStream, that.dataStream);
        }

        public int hashCode() {
            return Objects.hash(this.concreteIndex, this.isHidden, this.isSystem, this.dataStream);
        }
    }

    public static enum Type {
        CONCRETE_INDEX("concrete index"),
        ALIAS("alias"),
        DATA_STREAM("data_stream");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

