/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

public interface VersionId<T extends VersionId<T>>
extends Comparable<T> {
    public int id();

    default public boolean after(T version) {
        return version.id() < this.id();
    }

    default public boolean onOrAfter(T version) {
        return version.id() <= this.id();
    }

    default public boolean before(T version) {
        return version.id() > this.id();
    }

    default public boolean onOrBefore(T version) {
        return version.id() >= this.id();
    }

    default public boolean between(T lowerInclusive, T upperExclusive) {
        if (upperExclusive.onOrBefore(lowerInclusive)) {
            throw new IllegalArgumentException();
        }
        return this.onOrAfter(lowerInclusive) && this.before(upperExclusive);
    }

    @Override
    default public int compareTo(T o) {
        return Integer.compare(this.id(), o.id());
    }
}

