/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BytesRefStreamOutput
extends StreamOutput
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefStreamOutput.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRefBuilder.class);
    private final BytesRefBuilder builder = new BytesRefBuilder();

    public BytesRef get() {
        return this.builder.get();
    }

    @Override
    public long position() {
        return this.builder.length();
    }

    @Override
    public void writeByte(byte b) {
        this.builder.append(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        this.builder.append(b, offset, length);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.builder.clear();
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (long)this.builder.bytes().length;
    }

    byte[] bytes() {
        return this.builder.bytes();
    }
}

