/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class RatioValue
implements Writeable {
    private final double percent;

    public RatioValue(double percent) {
        this.percent = percent;
    }

    public double getAsRatio() {
        return this.percent / 100.0;
    }

    public double getAsPercent() {
        return this.percent;
    }

    public String toString() {
        return this.percent + "%";
    }

    public static RatioValue parseRatioValue(String sValue) {
        if (sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new ElasticsearchParseException("Percentage should be in [0-100], got [{}]", percentAsString);
                }
                return new RatioValue(Math.abs(percent));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchParseException("Failed to parse [{}] as a double", (Throwable)e, percentAsString);
            }
        }
        try {
            double ratio = Double.parseDouble(sValue);
            if (ratio < 0.0 || ratio > 1.0) {
                throw new ElasticsearchParseException("Ratio should be in [0-1.0], got [{}]", ratio);
            }
            return new RatioValue(100.0 * Math.abs(ratio));
        }
        catch (NumberFormatException e) {
            throw new ElasticsearchParseException("Invalid ratio or percentage [{}]", sValue);
        }
    }

    public String formatNoTrailingZerosPercent() {
        int i;
        String value = String.valueOf(this.getAsPercent());
        for (i = value.length() - 1; i >= 0 && value.charAt(i) == '0'; --i) {
        }
        if (i < 0) {
            return "0%";
        }
        if (value.charAt(i) == '.') {
            return value.substring(0, i) + "%";
        }
        return value.substring(0, Math.min(i + 1, value.length())) + "%";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.percent);
    }

    public static RatioValue readFrom(StreamInput in) throws IOException {
        return new RatioValue(in.readDouble());
    }
}

