/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.elasticsearch.common.util.AbstractBigByteArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;

final class BigFloatArray
extends AbstractBigByteArray
implements FloatArray {
    private static final BigFloatArray ESTIMATOR = new BigFloatArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.nativeOrder());
    private static final int PAGE_SHIFT = Integer.numberOfTrailingZeros(4096);

    BigFloatArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(4096, bigArrays, clearOnResize, size);
    }

    @Override
    public void set(long index, float value) {
        int pageIndex = BigFloatArray.pageIdx(index);
        int indexInPage = BigFloatArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        VH_PLATFORM_NATIVE_FLOAT.set(page, indexInPage << 2, value);
    }

    @Override
    public float get(long index) {
        int pageIndex = BigFloatArray.pageIdx(index);
        int indexInPage = BigFloatArray.idxInPage(index);
        return VH_PLATFORM_NATIVE_FLOAT.get(this.pages[pageIndex], indexInPage << 2);
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void fill(long fromIndex, long toIndex, float value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = BigFloatArray.pageIdx(fromIndex);
        if (fromPage == (toPage = BigFloatArray.pageIdx(toIndex - 1L))) {
            BigFloatArray.fill(this.getPageForWriting(fromPage), BigFloatArray.idxInPage(fromIndex), BigFloatArray.idxInPage(toIndex - 1L) + 1, value);
        } else {
            BigFloatArray.fill(this.getPageForWriting(fromPage), BigFloatArray.idxInPage(fromIndex), 4096, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigFloatArray.fill(this.getPageForWriting(i), 0, 4096, value);
            }
            BigFloatArray.fill(this.getPageForWriting(toPage), 0, BigFloatArray.idxInPage(toIndex - 1L) + 1, value);
        }
    }

    public static void fill(byte[] page, int from, int to, float value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_FLOAT.set(page, from << 2, value);
            BigFloatArray.fillBySelfCopy(page, from << 2, to << 2, 4);
        }
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, 2);
    }

    private static int pageIdx(long index) {
        return (int)(index >>> PAGE_SHIFT);
    }

    private static int idxInPage(long index) {
        return (int)(index & 0xFFFL);
    }
}

