/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.CheckedConsumer;

public class CloseUtils {
    private static final Exception SUCCEEDED = new Exception(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    public static final Executor NO_SHARDS_CREATED_EXECUTOR = r -> {
        assert (false) : r;
        r.run();
    };

    private CloseUtils() {
    }

    public static void executeDirectly(CheckedConsumer<ActionListener<Void>, IOException> action) throws IOException {
        final AtomicReference closeExceptionRef = new AtomicReference();
        ActionListener.run(ActionListener.assertOnce(new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                closeExceptionRef.set(SUCCEEDED);
            }

            @Override
            public void onFailure(Exception e) {
                closeExceptionRef.set(e);
            }
        }), action);
        Exception closeException = (Exception)closeExceptionRef.get();
        if (closeException == SUCCEEDED) {
            return;
        }
        if (closeException instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)closeException;
            throw runtimeException;
        }
        if (closeException instanceof IOException) {
            IOException ioException = (IOException)closeException;
            throw ioException;
        }
        assert (false) : closeException;
        if (closeException != null) {
            throw new RuntimeException("unexpected exception on shard close", closeException);
        }
    }
}

