/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.IntFunction;
import org.apache.lucene.util.Version;
import org.elasticsearch.ReleaseVersions;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.index.IndexVersion;

public class IndexVersions {
    static TreeSet<Integer> IDS = new TreeSet();
    public static final IndexVersion ZERO = IndexVersions.def(0, Version.LATEST);
    public static final IndexVersion V_7_0_0 = IndexVersions.def(7000099, IndexVersions.parseUnchecked("8.0.0"));
    public static final IndexVersion V_7_1_0 = IndexVersions.def(7010099, IndexVersions.parseUnchecked("8.0.0"));
    public static final IndexVersion V_7_2_0 = IndexVersions.def(7020099, IndexVersions.parseUnchecked("8.0.0"));
    public static final IndexVersion V_7_2_1 = IndexVersions.def(7020199, IndexVersions.parseUnchecked("8.0.0"));
    public static final IndexVersion V_7_3_0 = IndexVersions.def(7030099, IndexVersions.parseUnchecked("8.1.0"));
    public static final IndexVersion V_7_4_0 = IndexVersions.def(7040099, IndexVersions.parseUnchecked("8.2.0"));
    public static final IndexVersion V_7_5_0 = IndexVersions.def(7050099, IndexVersions.parseUnchecked("8.3.0"));
    public static final IndexVersion V_7_5_2 = IndexVersions.def(7050299, IndexVersions.parseUnchecked("8.3.0"));
    public static final IndexVersion V_7_6_0 = IndexVersions.def(7060099, IndexVersions.parseUnchecked("8.4.0"));
    public static final IndexVersion V_7_7_0 = IndexVersions.def(7070099, IndexVersions.parseUnchecked("8.5.1"));
    public static final IndexVersion V_7_8_0 = IndexVersions.def(7080099, IndexVersions.parseUnchecked("8.5.1"));
    public static final IndexVersion V_7_9_0 = IndexVersions.def(7090099, IndexVersions.parseUnchecked("8.6.0"));
    public static final IndexVersion V_7_10_0 = IndexVersions.def(7100099, IndexVersions.parseUnchecked("8.7.0"));
    public static final IndexVersion V_7_11_0 = IndexVersions.def(7110099, IndexVersions.parseUnchecked("8.7.0"));
    public static final IndexVersion V_7_12_0 = IndexVersions.def(7120099, IndexVersions.parseUnchecked("8.8.0"));
    public static final IndexVersion V_7_13_0 = IndexVersions.def(7130099, IndexVersions.parseUnchecked("8.8.2"));
    public static final IndexVersion V_7_14_0 = IndexVersions.def(7140099, IndexVersions.parseUnchecked("8.9.0"));
    public static final IndexVersion V_7_15_0 = IndexVersions.def(7150099, IndexVersions.parseUnchecked("8.9.0"));
    public static final IndexVersion V_7_16_0 = IndexVersions.def(7160099, IndexVersions.parseUnchecked("8.10.1"));
    public static final IndexVersion V_7_17_0 = IndexVersions.def(7170099, IndexVersions.parseUnchecked("8.11.1"));
    public static final IndexVersion V_8_0_0 = IndexVersions.def(8000099, Version.LUCENE_9_0_0);
    public static final IndexVersion V_8_1_0 = IndexVersions.def(8010099, Version.LUCENE_9_0_0);
    public static final IndexVersion V_8_2_0 = IndexVersions.def(8020099, Version.LUCENE_9_1_0);
    public static final IndexVersion V_8_3_0 = IndexVersions.def(8030099, Version.LUCENE_9_2_0);
    public static final IndexVersion V_8_4_0 = IndexVersions.def(8040099, Version.LUCENE_9_3_0);
    public static final IndexVersion V_8_5_0 = IndexVersions.def(8050099, Version.LUCENE_9_4_1);
    public static final IndexVersion V_8_5_3 = IndexVersions.def(8050399, Version.LUCENE_9_4_2);
    public static final IndexVersion V_8_6_0 = IndexVersions.def(8060099, Version.LUCENE_9_4_2);
    public static final IndexVersion V_8_7_0 = IndexVersions.def(8070099, Version.LUCENE_9_5_0);
    public static final IndexVersion V_8_8_0 = IndexVersions.def(8080099, Version.LUCENE_9_6_0);
    public static final IndexVersion V_8_8_2 = IndexVersions.def(8080299, Version.LUCENE_9_6_0);
    public static final IndexVersion V_8_9_0 = IndexVersions.def(8090099, Version.LUCENE_9_7_0);
    public static final IndexVersion V_8_9_1 = IndexVersions.def(8090199, Version.LUCENE_9_7_0);
    public static final IndexVersion V_8_10_0 = IndexVersions.def(8100099, Version.LUCENE_9_7_0);
    public static final IndexVersion FIRST_DETACHED_INDEX_VERSION = IndexVersions.def(8500000, Version.LUCENE_9_7_0);
    public static final IndexVersion NEW_SPARSE_VECTOR = IndexVersions.def(8500001, Version.LUCENE_9_7_0);
    public static final IndexVersion SPARSE_VECTOR_IN_FIELD_NAMES_SUPPORT = IndexVersions.def(8500002, Version.LUCENE_9_7_0);
    public static final IndexVersion UPGRADE_LUCENE_9_8 = IndexVersions.def(8500003, Version.LUCENE_9_8_0);
    public static final IndexVersion ES_VERSION_8_12 = IndexVersions.def(8500004, Version.LUCENE_9_8_0);
    public static final IndexVersion NORMALIZED_VECTOR_COSINE = IndexVersions.def(8500005, Version.LUCENE_9_8_0);
    public static final IndexVersion UPGRADE_LUCENE_9_9 = IndexVersions.def(8500006, Version.LUCENE_9_9_0);
    public static final IndexVersion NORI_DUPLICATES = IndexVersions.def(8500007, Version.LUCENE_9_9_0);
    public static final IndexVersion UPGRADE_LUCENE_9_9_1 = IndexVersions.def(8500008, Version.LUCENE_9_9_1);
    public static final IndexVersion ES_VERSION_8_12_1 = IndexVersions.def(8500009, Version.LUCENE_9_9_1);
    public static final IndexVersion UPGRADE_8_12_1_LUCENE_9_9_2 = IndexVersions.def(8500010, Version.LUCENE_9_9_2);
    public static final IndexVersion NEW_INDEXVERSION_FORMAT = IndexVersions.def(8501000, Version.LUCENE_9_9_1);
    public static final IndexVersion UPGRADE_LUCENE_9_9_2 = IndexVersions.def(8502000, Version.LUCENE_9_9_2);
    public static final IndexVersion TIME_SERIES_ID_HASHING = IndexVersions.def(8502001, Version.LUCENE_9_9_2);
    public static final IndexVersion UPGRADE_TO_LUCENE_9_10 = IndexVersions.def(8503000, Version.LUCENE_9_10_0);
    public static final IndexVersion TIME_SERIES_ROUTING_HASH_IN_ID = IndexVersions.def(8504000, Version.LUCENE_9_10_0);
    public static final IndexVersion DEFAULT_DENSE_VECTOR_TO_INT8_HNSW = IndexVersions.def(8505000, Version.LUCENE_9_10_0);
    public static final IndexVersion DOC_VALUES_FOR_IGNORED_META_FIELD = IndexVersions.def(8505001, Version.LUCENE_9_10_0);
    public static final IndexVersion SOURCE_MAPPER_LOSSY_PARAMS_CHECK = IndexVersions.def(8506000, Version.LUCENE_9_10_0);
    public static final IndexVersion SEMANTIC_TEXT_FIELD_TYPE = IndexVersions.def(8507000, Version.LUCENE_9_10_0);
    public static final IndexVersion UPGRADE_TO_LUCENE_9_11 = IndexVersions.def(8508000, Version.LUCENE_9_11_0);
    public static final IndexVersion UNIQUE_TOKEN_FILTER_POS_FIX = IndexVersions.def(8509000, Version.LUCENE_9_11_0);
    public static final IndexVersion ADD_SECURITY_MIGRATION = IndexVersions.def(8510000, Version.LUCENE_9_11_0);
    public static final IndexVersion UPGRADE_TO_LUCENE_9_11_1 = IndexVersions.def(8511000, Version.LUCENE_9_11_1);
    public static final IndexVersion INDEX_SORTING_ON_NESTED = IndexVersions.def(8512000, Version.LUCENE_9_11_1);
    public static final IndexVersion LENIENT_UPDATEABLE_SYNONYMS = IndexVersions.def(8513000, Version.LUCENE_9_11_1);
    public static final IndexVersion ENABLE_IGNORE_MALFORMED_LOGSDB = IndexVersions.def(8514000, Version.LUCENE_9_11_1);
    public static final IndexVersion MERGE_ON_RECOVERY_VERSION = IndexVersions.def(8515000, Version.LUCENE_9_11_1);
    public static final IndexVersion UPGRADE_TO_LUCENE_9_12 = IndexVersions.def(8516000, Version.LUCENE_9_12_0);
    public static final IndexVersion ENABLE_IGNORE_ABOVE_LOGSDB = IndexVersions.def(8517000, Version.LUCENE_9_12_0);
    public static final IndexVersion ADD_ROLE_MAPPING_CLEANUP_MIGRATION = IndexVersions.def(8518000, Version.LUCENE_9_12_0);
    public static final IndexVersion LOGSDB_DEFAULT_IGNORE_DYNAMIC_BEYOND_LIMIT_BACKPORT = IndexVersions.def(8519000, Version.LUCENE_9_12_0);
    public static final IndexVersion TIME_BASED_K_ORDERED_DOC_ID_BACKPORT = IndexVersions.def(8520000, Version.LUCENE_9_12_0);
    public static final IndexVersion V8_DEPRECATE_SOURCE_MODE_MAPPER = IndexVersions.def(8521000, Version.LUCENE_9_12_0);
    public static final IndexVersion USE_SYNTHETIC_SOURCE_FOR_RECOVERY_BACKPORT = IndexVersions.def(8522000, Version.LUCENE_9_12_0);
    public static final IndexVersion UPGRADE_TO_LUCENE_9_12_1 = IndexVersions.def(8523000, IndexVersions.parseUnchecked("9.12.1"));
    public static final IndexVersion INFERENCE_METADATA_FIELDS_BACKPORT = IndexVersions.def(8524000, IndexVersions.parseUnchecked("9.12.1"));
    public static final IndexVersion LOGSB_OPTIONAL_SORTING_ON_HOST_NAME_BACKPORT = IndexVersions.def(8525000, IndexVersions.parseUnchecked("9.12.1"));
    public static final IndexVersion UPGRADE_TO_LUCENE_10_0_0 = IndexVersions.def(9000000, Version.LUCENE_10_0_0);
    public static final IndexVersion LOGSDB_DEFAULT_IGNORE_DYNAMIC_BEYOND_LIMIT = IndexVersions.def(9001000, Version.LUCENE_10_0_0);
    public static final IndexVersion TIME_BASED_K_ORDERED_DOC_ID = IndexVersions.def(9002000, Version.LUCENE_10_0_0);
    public static final IndexVersion DEPRECATE_SOURCE_MODE_MAPPER = IndexVersions.def(9003000, Version.LUCENE_10_0_0);
    public static final IndexVersion USE_SYNTHETIC_SOURCE_FOR_RECOVERY = IndexVersions.def(9004000, Version.LUCENE_10_0_0);
    public static final IndexVersion INFERENCE_METADATA_FIELDS = IndexVersions.def(9005000, Version.LUCENE_10_0_0);
    public static final IndexVersion LOGSB_OPTIONAL_SORTING_ON_HOST_NAME = IndexVersions.def(9006000, Version.LUCENE_10_0_0);
    public static final IndexVersion SOURCE_MAPPER_MODE_ATTRIBUTE_NOOP = IndexVersions.def(9007000, Version.LUCENE_10_0_0);
    public static final IndexVersion HOSTNAME_DOC_VALUES_SPARSE_INDEX = IndexVersions.def(9008000, Version.LUCENE_10_0_0);
    public static final IndexVersion UPGRADE_TO_LUCENE_10_1_0 = IndexVersions.def(9009000, Version.LUCENE_10_1_0);
    public static final IndexVersion MINIMUM_COMPATIBLE = V_8_0_0;
    public static final IndexVersion MINIMUM_READONLY_COMPATIBLE = V_7_0_0;
    static final NavigableMap<Integer, IndexVersion> VERSION_IDS = IndexVersions.getAllVersionIds(IndexVersions.class);
    static final IndexVersion LATEST_DEFINED = VERSION_IDS.lastEntry().getValue();
    static final IntFunction<String> VERSION_LOOKUP;

    private static IndexVersion def(int id, Version luceneVersion) {
        if (IDS == null) {
            throw new IllegalStateException("The IDS map needs to be present to call this method");
        }
        if (!IDS.add(id)) {
            throw new IllegalArgumentException("Version id " + id + " defined twice");
        }
        if (id < IDS.last()) {
            throw new IllegalArgumentException("Version id " + id + " is not defined in the right location. Keep constants sorted");
        }
        return new IndexVersion(id, luceneVersion);
    }

    private static Version parseUnchecked(String version) {
        try {
            return Version.parse((String)version);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static NavigableMap<Integer, IndexVersion> getAllVersionIds(Class<?> cls) {
        HashMap<Integer, String> versionIdFields = new HashMap<Integer, String>();
        TreeMap<Integer, IndexVersion> builder = new TreeMap<Integer, IndexVersion>();
        Set<String> ignore = Set.of("ZERO", "MINIMUM_COMPATIBLE", "MINIMUM_READONLY_COMPATIBLE");
        for (Field declaredField : cls.getFields()) {
            IndexVersion version;
            String fieldName;
            if (!declaredField.getType().equals(IndexVersion.class) || ignore.contains(fieldName = declaredField.getName())) continue;
            try {
                version = (IndexVersion)declaredField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            builder.put(version.id(), version);
            if (!Assertions.ENABLED) continue;
            String sameVersionNumber = versionIdFields.put(version.id(), fieldName);
            assert (sameVersionNumber == null) : "Versions [" + sameVersionNumber + "] and [" + fieldName + "] have the same version number [" + version.id() + "]. Each IndexVersion should have a different version number";
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    static Collection<IndexVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    private IndexVersions() {
    }

    static {
        IDS = null;
        VERSION_LOOKUP = ReleaseVersions.generateVersionsLookup(IndexVersions.class, LATEST_DEFINED.id());
    }
}

