/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class FieldAliasMapper
extends Mapper {
    public static final String CONTENT_TYPE = "alias";
    private final String name;
    private final String targetPath;

    public FieldAliasMapper(String simpleName, String name, String targetPath) {
        super(simpleName);
        this.name = Mapper.internFieldName(name);
        this.targetPath = targetPath;
    }

    @Override
    public String fullPath() {
        return this.name;
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    public String targetPath() {
        return this.targetPath;
    }

    @Override
    public Mapper merge(Mapper mergeWith, MapperMergeContext mapperMergeContext) {
        if (!(mergeWith instanceof FieldAliasMapper)) {
            throw new IllegalArgumentException("Cannot merge a field alias mapping [" + this.fullPath() + "] with a mapping that is not for a field alias.");
        }
        return mergeWith;
    }

    @Override
    public Iterator<Mapper> iterator() {
        return Collections.emptyIterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject(this.leafName()).field("type", CONTENT_TYPE).field("path", this.targetPath).endObject();
    }

    @Override
    public void validate(MappingLookup mappers) {
        String pathScope;
        if (Objects.equals(this.targetPath(), this.fullPath())) {
            throw new MapperParsingException("Invalid [path] value [" + this.targetPath + "] for field alias [" + this.fullPath() + "]: an alias cannot refer to itself.");
        }
        if (mappers.fieldTypesLookup().get(this.targetPath) == null) {
            throw new MapperParsingException("Invalid [path] value [" + this.targetPath + "] for field alias [" + this.fullPath() + "]: an alias must refer to an existing field in the mappings.");
        }
        if (mappers.getMapper(this.targetPath) instanceof FieldAliasMapper) {
            throw new MapperParsingException("Invalid [path] value [" + this.targetPath + "] for field alias [" + this.fullPath() + "]: an alias cannot refer to another alias.");
        }
        String aliasScope = mappers.nestedLookup().getNestedParent(this.name);
        if (!Objects.equals(aliasScope, pathScope = mappers.nestedLookup().getNestedParent(this.targetPath))) {
            StringBuilder message = new StringBuilder("Invalid [path] value [" + this.targetPath + "] for field alias [" + this.name + "]: an alias must have the same nested scope as its target. ");
            message.append((String)(aliasScope == null ? "The alias is not nested" : "The alias's nested scope is [" + aliasScope + "]"));
            message.append(", but ");
            message.append((String)(pathScope == null ? "the target is not nested." : "the target's nested scope is [" + pathScope + "]."));
            throw new IllegalArgumentException(message.toString());
        }
    }

    @Override
    public int getTotalFieldsCount() {
        return 1;
    }

    public static class Names {
        public static final String PATH = "path";
    }

    public static class Builder
    extends Mapper.Builder {
        private String path;

        protected Builder(String name) {
            super(name);
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public FieldAliasMapper build(MapperBuilderContext context) {
            String fullName = context.buildFullName(this.leafName());
            return new FieldAliasMapper(this.leafName(), fullName, this.path);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Object pathField = node.remove("path");
            String path = XContentMapValues.nodeStringValue(pathField, null);
            if (path == null) {
                throw new MapperParsingException("The [path] property must be specified for field [" + name + "].");
            }
            return builder.path(path);
        }

        @Override
        public boolean supportsVersion(IndexVersion indexCreatedVersion) {
            return true;
        }
    }
}

