/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class LegacyTypeFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";
    public static final MappedFieldType FIELD_TYPE = new LegacyTypeFieldType();
    private static final LegacyTypeFieldMapper INSTANCE = new LegacyTypeFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> INSTANCE);
    private static final Map<String, NamedAnalyzer> ANALYZERS = Map.of("_type", Lucene.KEYWORD_ANALYZER);

    protected LegacyTypeFieldMapper() {
        super(FIELD_TYPE);
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return ANALYZERS;
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    private static final class LegacyTypeFieldType
    extends TermBasedFieldType {
        LegacyTypeFieldType() {
            super("_type", false, true, true, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_type";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            return SortedSetDocValuesField.newSlowExactQuery((String)this.name(), (BytesRef)this.indexedValueForSearch(value));
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            List<BytesRef> bytesRefs = values.stream().map(this::indexedValueForSearch).toList();
            return SortedSetDocValuesField.newSlowSetQuery((String)this.name(), bytesRefs);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            return SortedSetDocValuesField.newSlowRangeQuery((String)this.name(), (BytesRef)(lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm)), (BytesRef)(upperTerm == null ? null : this.indexedValueForSearch(upperTerm)), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return true;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), "_type");
        }
    }
}

