/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LeafRuntimeField;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.LookupField;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContentBuilder;

public final class LookupRuntimeFieldType
extends MappedFieldType {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(Builder::new);
    public static final String CONTENT_TYPE = "lookup";
    private final String lookupIndex;
    private final String inputField;
    private final String targetField;
    private final List<FieldAndFormat> fetchFields;

    private LookupRuntimeFieldType(String name, Map<String, String> meta, String lookupIndex, String inputField, String targetField, List<FieldAndFormat> fetchFields) {
        super(name, false, false, false, TextSearchInfo.NONE, meta);
        this.lookupIndex = lookupIndex;
        this.inputField = inputField;
        this.targetField = targetField;
        this.fetchFields = fetchFields;
    }

    @Override
    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        if (!context.allowExpensiveQueries()) {
            throw new ElasticsearchException("cannot be executed against lookup field [" + this.name() + "] while [" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "] is set to [false].", new Object[0]);
        }
        return new LookupFieldValueFetcher(context);
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        throw new IllegalArgumentException("Cannot search on field [" + this.name() + "] since it is a lookup field.");
    }

    private class LookupFieldValueFetcher
    implements ValueFetcher {
        private final ValueFetcher inputFieldValueFetcher;

        LookupFieldValueFetcher(SearchExecutionContext context) {
            MappedFieldType inputFieldType = context.getFieldType(LookupRuntimeFieldType.this.inputField);
            if (inputFieldType == null) {
                throw new QueryShardException((QueryRewriteContext)context, "No field mapping can be found for the field with name [{}]", LookupRuntimeFieldType.this.inputField);
            }
            this.inputFieldValueFetcher = inputFieldType.valueFetcher(context, null);
        }

        @Override
        public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
            assert (false) : "call #fetchDocumentField() instead";
            throw new UnsupportedOperationException("call #fetchDocumentField() instead");
        }

        @Override
        public DocumentField fetchDocumentField(String docName, Source source, int doc) throws IOException {
            DocumentField inputDoc = this.inputFieldValueFetcher.fetchDocumentField(LookupRuntimeFieldType.this.inputField, source, doc);
            if (inputDoc == null || inputDoc.getValues().isEmpty()) {
                return null;
            }
            List<LookupField> lookupFields = inputDoc.getValues().stream().map(input -> {
                TermQueryBuilder query = new TermQueryBuilder(LookupRuntimeFieldType.this.targetField, input.toString());
                return new LookupField(LookupRuntimeFieldType.this.lookupIndex, query, LookupRuntimeFieldType.this.fetchFields, 1);
            }).toList();
            return new DocumentField(docName, List.of(), List.of(), lookupFields);
        }

        @Override
        public void setNextReader(LeafReaderContext context) {
            this.inputFieldValueFetcher.setNextReader(context);
        }

        @Override
        public StoredFieldsSpec storedFieldsSpec() {
            return this.inputFieldValueFetcher.storedFieldsSpec();
        }
    }

    private static class Builder
    extends RuntimeField.Builder {
        private final FieldMapper.Parameter<String> targetIndex = FieldMapper.Parameter.stringParam("target_index", false, RuntimeField.initializerNotSupported(), null).addValidator(v -> {
            if (Strings.isEmpty(v)) {
                throw new IllegalArgumentException("[target_index] parameter must be specified");
            }
        });
        private final FieldMapper.Parameter<String> inputField = FieldMapper.Parameter.stringParam("input_field", false, RuntimeField.initializerNotSupported(), null).addValidator(inputField -> {
            if (Strings.isEmpty(inputField)) {
                throw new IllegalArgumentException("[input_field] parameter must be specified");
            }
            if (inputField.equals(this.name)) {
                throw new IllegalArgumentException("lookup field [" + this.name + "] can't use input from itself");
            }
        });
        private final FieldMapper.Parameter<String> targetField = FieldMapper.Parameter.stringParam("target_field", false, RuntimeField.initializerNotSupported(), null).addValidator(targetField -> {
            if (Strings.isEmpty(targetField)) {
                throw new IllegalArgumentException("[target_field] parameter must be specified");
            }
        });
        private final FieldMapper.Parameter<List<FieldAndFormat>> fetchFields = Builder.newFetchFields();

        private static FieldMapper.Parameter<List<FieldAndFormat>> newFetchFields() {
            FieldMapper.Parameter<List<FieldAndFormat>> fetchFields = new FieldMapper.Parameter<List<FieldAndFormat>>("fetch_fields", false, List::of, (s, ctx, o) -> Builder.parseFetchFields(o), RuntimeField.initializerNotSupported(), XContentBuilder::field, Object::toString);
            fetchFields.addValidator(fields -> {
                if (fields.isEmpty()) {
                    throw new MapperParsingException("[fetch_fields] parameter must not be empty");
                }
            });
            return fetchFields;
        }

        private static List<FieldAndFormat> parseFetchFields(Object o) {
            List values = (List)o;
            return values.stream().map(v -> {
                if (v instanceof Map) {
                    Map m = (Map)v;
                    String field = (String)m.get(FieldAndFormat.FIELD_FIELD.getPreferredName());
                    String format = (String)m.get(FieldAndFormat.FORMAT_FIELD.getPreferredName());
                    if (field == null) {
                        throw new MapperParsingException("[field] parameter of [fetch_fields] must be provided");
                    }
                    return new FieldAndFormat(field, format);
                }
                if (v instanceof String) {
                    String s = (String)v;
                    return new FieldAndFormat(s, null);
                }
                throw new MapperParsingException("unexpected value [" + String.valueOf(v) + "] for [fetch_fields] parameter");
            }).toList();
        }

        Builder(String name) {
            super(name);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            ArrayList parameters = new ArrayList(super.getParameters());
            parameters.add(this.targetIndex);
            parameters.add(this.inputField);
            parameters.add(this.targetField);
            parameters.add(this.fetchFields);
            return parameters;
        }

        @Override
        protected RuntimeField createRuntimeField(MappingParserContext parserContext) {
            LookupRuntimeFieldType ft = new LookupRuntimeFieldType(this.name, this.meta(), this.targetIndex.get(), this.inputField.get(), this.targetField.get(), this.fetchFields.get());
            return new LeafRuntimeField(this.name, ft, this.getParameters());
        }

        @Override
        protected RuntimeField createChildRuntimeField(MappingParserContext parserContext, String parentName, Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory, OnScriptError onScriptError) {
            return this.createRuntimeField(parserContext);
        }
    }
}

