/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.LongConsumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class SnapshotFilesProvider {
    private final RepositoriesService repositoriesService;

    public SnapshotFilesProvider(RepositoriesService repositoriesService) {
        this.repositoriesService = Objects.requireNonNull(repositoriesService);
    }

    public InputStream getInputStreamForSnapshotFile(String repositoryName, IndexId indexId, ShardId shardId, final BlobStoreIndexShardSnapshot.FileInfo fileInfo, LongConsumer rateLimiterListener) {
        InputStream inputStream;
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repositoriesService.repository(repositoryName);
        StoreFileMetadata storeFileMetadata = fileInfo.metadata();
        if (storeFileMetadata.hashEqualsContents()) {
            BytesRef content = storeFileMetadata.hash();
            inputStream = new ByteArrayInputStream(content.bytes, content.offset, content.length);
        } else {
            final BlobContainer container = blobStoreRepository.shardContainer(indexId, shardId.id());
            inputStream = new SlicedInputStream(this, fileInfo.numberOfParts()){

                @Override
                protected InputStream openSlice(int slice) throws IOException {
                    return container.readBlob(OperationPurpose.SNAPSHOT_DATA, fileInfo.partName(slice));
                }

                @Override
                public boolean markSupported() {
                    return false;
                }
            };
        }
        return blobStoreRepository.maybeRateLimitRestores(inputStream, rateLimiterListener::accept);
    }

    public int getReadSnapshotFileBufferSizeForRepo(String repository) {
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repositoriesService.repository(repository);
        return blobStoreRepository.getReadBufferSizeInBytes();
    }
}

