/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.util.EnumSet;
import org.elasticsearch.common.Strings;

public enum ChunkingStrategy {
    WORD("word"),
    SENTENCE("sentence");

    private final String chunkingStrategy;

    private ChunkingStrategy(String strategy) {
        this.chunkingStrategy = strategy;
    }

    public String toString() {
        return this.chunkingStrategy;
    }

    public static ChunkingStrategy fromString(String strategy) {
        return EnumSet.allOf(ChunkingStrategy.class).stream().filter(cs -> cs.chunkingStrategy.equals(strategy)).findFirst().orElseThrow(() -> new IllegalArgumentException(Strings.format("Invalid chunkingStrategy %s", strategy)));
    }
}

