/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract class RestActionListener<Response>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(RestActionListener.class);
    protected final RestChannel channel;

    protected RestActionListener(RestChannel channel) {
        this.channel = channel;
    }

    @Override
    public final void onResponse(Response response) {
        try {
            this.ensureOpen();
            this.processResponse(response);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    protected abstract void processResponse(Response var1) throws Exception;

    protected void ensureOpen() {
        if (!this.channel.request().getHttpChannel().isOpen()) {
            throw new TaskCancelledException("response channel [" + String.valueOf(this.channel.request().getHttpChannel()) + "] closed");
        }
    }

    @Override
    public final void onFailure(Exception e) {
        try {
            this.channel.sendResponse(new RestResponse(this.channel, e));
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error("failed to send failure response", (Throwable)inner);
        }
    }
}

